@extends('admin.admin')

@section('title', 'Create Paradigm Profile Template')

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/remixicon@2.5.0/fonts/remixicon.css" rel="stylesheet">
<style>
    .template-create-container {
        max-width: 1200px;
        margin: 0 auto;
    }
    
    .page-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2rem;
        border-radius: 12px;
        margin-bottom: 2rem;
        box-shadow: 0 4px 20px rgba(102, 126, 234, 0.3);
    }
    
    .page-header h3 {
        font-weight: 700;
        font-size: 1.75rem;
        color: white;
    }
    
    .page-header p {
        opacity: 0.9;
        font-size: 1rem;
        color: white;
    }
    
    .back-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        background: rgba(255, 255, 255, 0.2);
        border: 1px solid rgba(255, 255, 255, 0.3);
        border-radius: 8px;
        color: white;
        text-decoration: none;
        transition: all 0.3s ease;
    }
    
    .back-btn:hover {
        background: rgba(255, 255, 255, 0.3);
        color: white;
        transform: translateX(-2px);
    }
    
    .create-section {
        background: white;
        border-radius: 10px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    .section-title {
        color: #333;
        font-weight: 600;
        margin-bottom: 1rem;
        padding-bottom: 0.5rem;
        border-bottom: 2px solid #e9ecef;
    }
    
    .field-item {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 1rem;
        margin-bottom: 1rem;
    }
    
    .question-item {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 1.5rem;
        margin-bottom: 1rem;
    }
    
    .badge-item {
        background: #f8f9fa;
        border: 1px solid #e9ecef;
        border-radius: 8px;
        padding: 1rem;
        margin-bottom: 1rem;
    }
    
    .add-btn {
        background: #28a745;
        color: white;
        border: none;
        padding: 0.5rem 1rem;
        border-radius: 5px;
        cursor: pointer;
        margin-bottom: 1rem;
    }
    
    .add-btn:hover {
        background: #218838;
    }
    
    .remove-btn {
        background: #dc3545;
        color: white;
        border: none;
        padding: 0.25rem 0.5rem;
        border-radius: 3px;
        cursor: pointer;
        font-size: 0.8rem;
    }
    
    .remove-btn:hover {
        background: #c82333;
    }
</style>
@endpush

@section('content')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div class="page-title">
                    <div class="d-flex align-items-center">
                        <a href="{{ route('admin.paradigm.templates.index') }}" class="back-btn me-3">
                            <i class="ri-arrow-left-line"></i>
                        </a>
                        <div>
                            <h3 class="mb-0 text-white">{{ __('Create Paradigm Profile Template') }}</h3>
                            <p class="text-white mb-0" style="opacity: 0.9;">{{ __('Create a new comprehensive personality assessment template') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="template-create-container">
            <form id="template-create-form">
                @csrf
                
                <!-- Template Basic Info -->
                <div class="create-section">
                    <h5 class="section-title">{{ __('Template Information') }}</h5>
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name" class="form-label">{{ __('Template Name') }} <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="name" name="name" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="is_active" class="form-label">{{ __('Status') }}</label>
                                <select class="form-select" id="is_active" name="is_active">
                                    <option value="1" selected>{{ __('Active') }}</option>
                                    <option value="0">{{ __('Inactive') }}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <label for="description" class="form-label">{{ __('Description') }}</label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                </div>

                <!-- Personal Fields -->
                <div class="create-section">
                    <h5 class="section-title">{{ __('Personal Fields') }}</h5>
                    <button type="button" class="add-btn" onclick="addPersonalField()">
                        <i class="ri-add-line me-2"></i>{{ __('Add Personal Field') }}
                    </button>
                    <div id="personal-fields-container">
                        <!-- Personal fields will be added here -->
                    </div>
                </div>

                <!-- Questions -->
                <div class="create-section">
                    <h5 class="section-title">{{ __('Assessment Questions') }}</h5>
                    <button type="button" class="add-btn" onclick="addQuestion()">
                        <i class="ri-add-line me-2"></i>{{ __('Add Question') }}
                    </button>
                    <div id="questions-container">
                        <!-- Questions will be added here -->
                    </div>
                </div>

                <!-- Badge Titles -->
                <div class="create-section">
                    <h5 class="section-title">{{ __('Badge Titles') }}</h5>
                    <button type="button" class="add-btn" onclick="addBadgeTitle()">
                        <i class="ri-add-line me-2"></i>{{ __('Add Badge Title') }}
                    </button>
                    <div id="badge-titles-container">
                        <!-- Badge titles will be added here -->
                    </div>
                </div>

                <!-- Action Buttons -->
                <div class="create-section">
                    <div class="d-flex justify-content-between">
                        <a href="{{ route('admin.paradigm.templates.index') }}" class="btn btn-outline-secondary">
                            <i class="ri-arrow-left-line me-2"></i>{{ __('Cancel') }}
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="ri-save-line me-2"></i>{{ __('Create Template') }}
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
let personalFieldCount = 0;
let questionCount = 0;
let badgeTitleCount = 0;

document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('template-create-form');
    
    // Add default personal fields
    addPersonalField('name', 'Name', 'text', true);
    addPersonalField('surname', 'Surname', 'text', true);
    addPersonalField('gender', 'Gender', 'select', true);
    addPersonalField('age', 'Age Range', 'select', true);
    addPersonalField('email', 'Email', 'email', true);
    addPersonalField('phone', 'Phone', 'tel', false);
    
    // Add default badge titles for Paradigm Profile types
    const paradigmTypes = [
        'The Analyst', 'The Organiser', 'The Visionary', 'The Helper',
        'The Specialist', 'The Strategist', 'The Advisor', 'The Architect',
        'The Harmoniser', 'The Creator', 'The Innovator', 'The Stabiliser',
        'The Integrator', 'The Vision Builder', 'The Whole-Brain Thinker'
    ];
    paradigmTypes.forEach(type => {
        addBadgeTitle(type, `The ${type} Personality`);
    });
    
    form.addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formData = new FormData(form);
        
        // Show loading state
        const submitBtn = form.querySelector('button[type="submit"]');
        const originalText = submitBtn.innerHTML;
        submitBtn.innerHTML = '<i class="ri-loader-4-line me-2"></i>{{ __("Creating...") }}';
        submitBtn.disabled = true;
        
        fetch('{{ route("admin.paradigm.templates.store") }}', {
            method: 'POST',
            body: formData,
            headers: {
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                if (typeof toastr !== 'undefined') {
                    toastr.success('{{ __("Template created successfully") }}');
                }
                setTimeout(() => {
                    window.location.href = `/admin/paradigm/templates/${data.template.id}`;
                }, 1000);
            } else {
                if (typeof toastr !== 'undefined') {
                    toastr.error(data.message || '{{ __("Error creating template") }}');
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
            if (typeof toastr !== 'undefined') {
                toastr.error('{{ __("An error occurred. Please try again.") }}');
            }
        })
        .finally(() => {
            submitBtn.innerHTML = originalText;
            submitBtn.disabled = false;
        });
    });
});

function addPersonalField(fieldKey = '', fieldLabel = '', fieldType = 'text', isRequired = true) {
    personalFieldCount++;
    const container = document.getElementById('personal-fields-container');
    
    const fieldHtml = `
        <div class="field-item" data-field-index="${personalFieldCount}">
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label">{{ __('Field Key') }}</label>
                    <input type="text" class="form-control" name="personal_fields[${personalFieldCount}][field_key]" value="${fieldKey}" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">{{ __('Field Label') }}</label>
                    <input type="text" class="form-control" name="personal_fields[${personalFieldCount}][field_label]" value="${fieldLabel}" required>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Field Type') }}</label>
                    <select class="form-select" name="personal_fields[${personalFieldCount}][field_type]" onchange="updateFieldOptions(${personalFieldCount})">
                        <option value="text" ${fieldType === 'text' ? 'selected' : ''}>{{ __('Text') }}</option>
                        <option value="select" ${fieldType === 'select' ? 'selected' : ''}>{{ __('Select') }}</option>
                        <option value="email" ${fieldType === 'email' ? 'selected' : ''}>{{ __('Email') }}</option>
                        <option value="tel" ${fieldType === 'tel' ? 'selected' : ''}>{{ __('Phone') }}</option>
                        <option value="radio" ${fieldType === 'radio' ? 'selected' : ''}>{{ __('Radio') }}</option>
                        <option value="checkbox" ${fieldType === 'checkbox' ? 'selected' : ''}>{{ __('Checkbox') }}</option>
                        <option value="time" ${fieldType === 'time' ? 'selected' : ''}>{{ __('Time') }}</option>
                        <option value="datetime-local" ${fieldType === 'datetime-local' ? 'selected' : ''}>{{ __('Date & Time') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Required') }}</label>
                    <select class="form-select" name="personal_fields[${personalFieldCount}][is_required]">
                        <option value="1" ${isRequired ? 'selected' : ''}>{{ __('Yes') }}</option>
                        <option value="0" ${!isRequired ? 'selected' : ''}>{{ __('No') }}</option>
                    </select>
                </div>
                <div class="col-md-1">
                    <label class="form-label">{{ __('Order') }}</label>
                    <input type="number" class="form-control" name="personal_fields[${personalFieldCount}][display_order]" value="${personalFieldCount}">
                </div>
                <div class="col-md-1">
                    <label class="form-label">&nbsp;</label>
                    <button type="button" class="btn btn-danger btn-sm w-100" onclick="removePersonalField(${personalFieldCount})">
                        <i class="ri-delete-bin-line"></i>
                    </button>
                </div>
            </div>
            <div class="row mt-2" id="options-${personalFieldCount}" style="display: none;">
                <div class="col-12">
                    <label class="form-label">{{ __('Options') }}</label>
                    <textarea class="form-control" name="personal_fields[${personalFieldCount}][options]" rows="2" placeholder="{{ __('One option per line') }}"></textarea>
                </div>
            </div>
        </div>
    `;
    
    container.insertAdjacentHTML('beforeend', fieldHtml);
    
    // Show options for select fields
    if (fieldType === 'select') {
        updateFieldOptions(personalFieldCount);
    }
}

function addQuestion() {
    questionCount++;
    const container = document.getElementById('questions-container');
    
    const questionHtml = `
        <div class="question-item" data-question-index="${questionCount}">
            <div class="row">
                <div class="col-md-1">
                    <label class="form-label">{{ __('Order') }}</label>
                    <input type="number" class="form-control" name="questions[${questionCount}][display_order]" value="${questionCount}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Module') }}</label>
                    <select class="form-select" name="questions[${questionCount}][assessment_module]">
                        <option value="balance_profile">Balance Profile</option>
                        <option value="conflict_styles">Conflict Styles</option>
                        <option value="connection_styles">Connection Styles</option>
                        <option value="personality_blueprint">Personality Blueprint</option>
                        <option value="serq">SERQ</option>
                        <option value="brain_frames">Brain Frames</option>
                        <option value="brain_fields">Brain Fields</option>
                        <option value="type_classification">Type Classification</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Question Type') }}</label>
                    <select class="form-select" name="questions[${questionCount}][question_type]">
                        <option value="rating_scale">Rating Scale</option>
                        <option value="multiple_choice">Multiple Choice</option>
                        <option value="ranking">Ranking</option>
                        <option value="binary_choice">Binary Choice</option>
                    </select>
                </div>
                <div class="col-md-1">
                    <label class="form-label">{{ __('Min') }}</label>
                    <input type="number" class="form-control" name="questions[${questionCount}][rating_scale_min]" value="1">
                </div>
                <div class="col-md-1">
                    <label class="form-label">{{ __('Max') }}</label>
                    <input type="number" class="form-control" name="questions[${questionCount}][rating_scale_max]" value="4">
                </div>
                <div class="col-md-1">
                    <label class="form-label">{{ __('Required') }}</label>
                    <select class="form-select" name="questions[${questionCount}][is_required]">
                        <option value="1" selected>{{ __('Yes') }}</option>
                        <option value="0">{{ __('No') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <label class="form-label">&nbsp;</label>
                    <button type="button" class="btn btn-danger btn-sm w-100" onclick="removeQuestion(${questionCount})">
                        <i class="ri-delete-bin-line"></i>
                    </button>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-12">
                    <label class="form-label">{{ __('Question Text') }}</label>
                    <textarea class="form-control" name="questions[${questionCount}][question_text]" rows="2" required placeholder="{{ __('Enter your question here...') }}"></textarea>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-md-6">
                    <label class="form-label">{{ __('Option A Label') }}</label>
                    <input type="text" class="form-control" name="questions[${questionCount}][option_a_label]" required placeholder="{{ __('Option A') }}">
                </div>
                <div class="col-md-6">
                    <label class="form-label">{{ __('Option B Label') }}</label>
                    <input type="text" class="form-control" name="questions[${questionCount}][option_b_label]" required placeholder="{{ __('Option B') }}">
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-md-4">
                    <label class="form-label">{{ __('Option C Label') }}</label>
                    <input type="text" class="form-control" name="questions[${questionCount}][option_c_label]" placeholder="{{ __('Option C (Optional)') }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">{{ __('Option D Label') }}</label>
                    <input type="text" class="form-control" name="questions[${questionCount}][option_d_label]" placeholder="{{ __('Option D (Optional)') }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">{{ __('Option E Label') }}</label>
                    <input type="text" class="form-control" name="questions[${questionCount}][option_e_label]" placeholder="{{ __('Option E (Optional)') }}">
                </div>
            </div>
        </div>
    `;
    
    container.insertAdjacentHTML('beforeend', questionHtml);
}

function addBadgeTitle(typeCode = '', badgeTitle = '') {
    badgeTitleCount++;
    const container = document.getElementById('badge-titles-container');
    
    const badgeHtml = `
        <div class="badge-item" data-badge-index="${badgeTitleCount}">
            <div class="row">
                <div class="col-md-3">
                    <label class="form-label">{{ __('Type Code') }}</label>
                    <input type="text" class="form-control" name="badge_titles[${badgeTitleCount}][type_code]" value="${typeCode}" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">{{ __('Badge Title') }}</label>
                    <input type="text" class="form-control" name="badge_titles[${badgeTitleCount}][badge_title]" value="${badgeTitle}" required>
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Category') }}</label>
                    <input type="text" class="form-control" name="badge_titles[${badgeTitleCount}][category]" placeholder="{{ __('Category') }}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">{{ __('Preference Level') }}</label>
                    <input type="text" class="form-control" name="badge_titles[${badgeTitleCount}][preference_level]" placeholder="{{ __('Preference Level') }}">
                </div>
                <div class="col-md-1">
                    <label class="form-label">&nbsp;</label>
                    <button type="button" class="btn btn-danger btn-sm w-100" onclick="removeBadgeTitle(${badgeTitleCount})">
                        <i class="ri-delete-bin-line"></i>
                    </button>
                </div>
            </div>
            <div class="row mt-2">
                <div class="col-12">
                    <label class="form-label">{{ __('Description') }}</label>
                    <textarea class="form-control" name="badge_titles[${badgeTitleCount}][description]" rows="2"></textarea>
                </div>
            </div>
        </div>
    `;
    
    container.insertAdjacentHTML('beforeend', badgeHtml);
}

function updateFieldOptions(fieldIndex) {
    const fieldType = document.querySelector(`select[name="personal_fields[${fieldIndex}][field_type]"]`).value;
    const optionsDiv = document.getElementById(`options-${fieldIndex}`);
    
    if (['select', 'radio', 'checkbox'].includes(fieldType)) {
        optionsDiv.style.display = 'block';
    } else {
        optionsDiv.style.display = 'none';
    }
}

function removePersonalField(fieldIndex) {
    const field = document.querySelector(`[data-field-index="${fieldIndex}"]`);
    if (field) {
        field.remove();
    }
}

function removeQuestion(questionIndex) {
    const question = document.querySelector(`[data-question-index="${questionIndex}"]`);
    if (question) {
        question.remove();
    }
}

function removeBadgeTitle(badgeIndex) {
    const badge = document.querySelector(`[data-badge-index="${badgeIndex}"]`);
    if (badge) {
        badge.remove();
    }
}
</script>
@endpush
