@extends('admin.admin')

@section('title', 'Assessment Template Details')

@push('styles')
<style>
    .page-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2rem;
        border-radius: 12px;
        margin-bottom: 2rem;
        box-shadow: 0 4px 20px rgba(102, 126, 234, 0.3);
    }
    
    .page-header h3 {
        font-weight: 700;
        font-size: 1.75rem;
        color: white;
    }
    
    .page-header p {
        opacity: 0.9;
        font-size: 1rem;
        color: white;
    }
    
    .back-btn {
        display: inline-flex;
        align-items: center;
        justify-content: center;
        width: 40px;
        height: 40px;
        background: rgba(255, 255, 255, 0.2);
        border: 1px solid rgba(255, 255, 255, 0.3);
        border-radius: 8px;
        color: white;
        text-decoration: none;
        transition: all 0.3s ease;
    }
    
    .back-btn:hover {
        background: rgba(255, 255, 255, 0.3);
        color: white;
        transform: translateX(-2px);
    }
</style>
@endpush

@section('content')
<div class="page-wrapper">
    <div class="content">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <div class="page-title">
                    <div class="d-flex align-items-center">
                        <a href="{{ route('admin.paradigm.templates.index') }}" class="back-btn me-3">
                            <i class="ri-arrow-left-line"></i>
                        </a>
                        <div>
                            <h3 class="mb-0 text-white">{{ $template->name }}</h3>
                            <p class="text-white mb-0" style="opacity: 0.9;">{{ __('Template Details') }}</p>
                        </div>
                    </div>
                </div>
                <div class="page-btn">
                    <a href="{{ route('admin.paradigm.templates.edit', $template) }}" class="btn btn-primary me-2">
                        <i class="ti ti-edit me-2"></i>{{ __('Edit Template') }}
                    </a>
                    <button type="button" class="btn btn-info" onclick="previewForm()">
                        <i class="ti ti-eye me-2"></i>{{ __('Preview Form') }}
                    </button>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Template Info -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">{{ __('Template Information') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6>{{ __('Name') }}</h6>
                                <p>{{ $template->name }}</p>
                            </div>
                            <div class="col-md-6">
                                <h6>{{ __('Status') }}</h6>
                                <span class="badge {{ $template->is_active ? 'badge-success' : 'badge-danger' }}">
                                    {{ $template->is_active ? __('Active') : __('Inactive') }}
                                </span>
                            </div>
                        </div>
                        
                        @if($template->description)
                        <div class="row">
                            <div class="col-12">
                                <h6>{{ __('Description') }}</h6>
                                <p>{{ $template->description }}</p>
                            </div>
                        </div>
                        @endif
                    </div>
                </div>

                <!-- Shortcode Section -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">{{ __('Shortcode') }}</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">{{ __('Use this shortcode to display the Assessment form on any page:') }}</p>
                        
                        <div class="input-group mb-3">
                            <input type="text" class="form-control" value="{{ $template->getShortcode() }}" readonly>
                            <button class="btn btn-outline-secondary copy-shortcode" type="button" data-shortcode="{{ $template->getShortcode() }}">
                                <i class="ti ti-copy"></i> {{ __('Copy') }}
                            </button>
                        </div>
                        
                        <div class="mt-3">
                            <h6>{{ __('Advanced Shortcode Options') }}</h6>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" value="{{ $template->getShortcodeWithAttributes(['title' => 'Custom Title']) }}" readonly>
                                        <button class="btn btn-outline-secondary copy-shortcode" type="button" data-shortcode="{{ $template->getShortcodeWithAttributes(['title' => 'Custom Title']) }}">
                                            <i class="ti ti-copy"></i>
                                        </button>
                                    </div>
                                    <small class="text-muted">With custom title</small>
                                </div>
                                <div class="col-md-6">
                                    <div class="input-group mb-2">
                                        <input type="text" class="form-control" value="{{ $template->getShortcodeWithAttributes(['theme' => 'dark']) }}" readonly>
                                        <button class="btn btn-outline-secondary copy-shortcode" type="button" data-shortcode="{{ $template->getShortcodeWithAttributes(['theme' => 'dark']) }}">
                                            <i class="ti ti-copy"></i>
                                        </button>
                                    </div>
                                    <small class="text-muted">With dark theme</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Statistics -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-header">
                        <h5 class="mb-0">{{ __('Statistics') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="stats-item mb-3">
                            <div class="d-flex justify-content-between">
                                <span>{{ __('Personal Fields') }}</span>
                                <span class="badge badge-primary">{{ $template->personalFields->count() }}</span>
                            </div>
                        </div>
                        
                        <div class="stats-item mb-3">
                            <div class="d-flex justify-content-between">
                                <span>{{ __('Total Questions') }}</span>
                                <span class="badge badge-primary">{{ $template->questions->count() }}</span>
                            </div>
                        </div>
                        
                        <div class="stats-item mb-3">
                            <div class="d-flex justify-content-between">
                                <span>{{ __('Questions by Module') }}</span>
                            </div>
                            <div class="mt-2">
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 1</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_1')->count() }}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 2</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_2')->count() }}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 3</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_3')->count() }}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 4</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_4')->count() }}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 5</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_5')->count() }}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 6</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_6')->count() }}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 7</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_7')->count() }}</small>
                                </div>
                                <div class="d-flex justify-content-between mb-1">
                                    <small>Custom Module 8</small>
                                    <small class="badge badge-info">{{ $template->getQuestionsByModule('custom_module_8')->count() }}</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="stats-item mb-3">
                            <div class="d-flex justify-content-between">
                                <span>{{ __('Custom Elements') }}</span>
                                <span class="badge badge-primary">{{ $template->badgeTitles->count() }}</span>
                            </div>
                        </div>
                        
                        <div class="stats-item mb-3">
                            <div class="d-flex justify-content-between">
                                <span>{{ __('PDF Pages') }}</span>
                                <span class="badge badge-primary">{{ $template->pdfPages->count() }}</span>
                            </div>
                        </div>
                        
                        <div class="stats-item">
                            <div class="d-flex justify-content-between">
                                <span>{{ __('Assessment Results') }}</span>
                                <span class="badge badge-success">{{ $template->assessmentResults->count() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.stats-item {
    border-bottom: 1px solid #e9ecef;
    padding-bottom: 0.5rem;
}

.stats-item:last-child {
    border-bottom: none;
    padding-bottom: 0;
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Copy shortcode functionality
    document.querySelectorAll('.copy-shortcode').forEach(button => {
        button.addEventListener('click', function() {
            const shortcode = this.dataset.shortcode;
            
            navigator.clipboard.writeText(shortcode).then(() => {
                if (typeof toastr !== 'undefined') {
                    toastr.success('{{ __("Shortcode copied to clipboard!") }}');
                } else {
                    alert('{{ __("Shortcode copied to clipboard!") }}');
                }
            }).catch(err => {
                // Fallback
                const input = this.parentElement.querySelector('input');
                input.select();
                document.execCommand('copy');
                
                if (typeof toastr !== 'undefined') {
                    toastr.success('{{ __("Shortcode copied to clipboard!") }}');
                } else {
                    alert('{{ __("Shortcode copied to clipboard!") }}');
                }
            });
        });
    });
});

function previewForm() {
    const shortcode = '{{ $template->getShortcode() }}';
    const previewUrl = `/admin/paradigm/templates/{{ $template->id }}/preview`;
    
    // Open preview in new window
    window.open(previewUrl, '_blank', 'width=800,height=600,scrollbars=yes,resizable=yes');
}
</script>
@endsection
