@extends('front')

@section('content')
<style>
    * {
        box-sizing: border-box;
    }
    
    .sales-page {
        max-width: 800px;
        margin: 0 auto;
        padding: 0;
        font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
        line-height: 1.5;
        color: #1a1a1a;
        background: #ffffff;
    }
    
    /* Chatbot Section - At Top */
    .chatbot-section {
        padding: 20px;
        background: #fff;
        margin-bottom: 30px;
        max-width: 600px;
        margin-left: auto;
        margin-right: auto;
    }
    
    .chatbot-container {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        overflow: hidden;
        border: 1px solid #e5e5e5;
        max-width: 100%;
    }
    
    .chatbot-header {
        background: linear-gradient(135deg, #044f54 0%, #033a3f 100%);
        color: white;
        padding: 15px 20px;
        text-align: left;
    }
    
    .chatbot-header h3 {
        margin: 0;
        font-size: 1.1rem;
        font-weight: 600;
        color: white;
    }
    
    .chat-messages {
        height: 350px;
        overflow-y: auto;
        padding: 15px;
        background: #fafafa;
        text-align: left !important;
    }
    
    .chat-message {
        margin-bottom: 12px;
        text-align: left !important;
        display: block;
    }
    
    .bot-message {
        text-align: left !important;
        display: block;
    }
    
    .bot-message .message-content {
        background: white;
        padding: 10px 14px;
        border-radius: 10px;
        display: block;
        max-width: 85%;
        box-shadow: 0 1px 3px rgba(0,0,0,0.05);
        line-height: 1.5;
        font-size: 14px;
        text-align: left;
        margin-left: 0;
        margin-right: auto;
    }
    
    .user-message {
        text-align: left !important;
        display: block;
    }
    
    .user-message .message-content {
        background: #044f54;
        color: white;
        padding: 10px 14px;
        border-radius: 10px;
        display: block;
        max-width: 85%;
        line-height: 1.5;
        font-size: 14px;
        text-align: left;
        margin-left: 0;
        margin-right: auto;
    }
    
    .chat-input-area {
        padding: 15px;
        background: white;
        border-top: 1px solid #e5e5e5;
    }
    
    .chat-input-group {
        display: flex;
        gap: 8px;
    }
    
    .chat-input-group input {
        flex: 1;
        padding: 12px 14px;
        border: 1px solid #e5e5e5;
        border-radius: 8px;
        font-size: 14px;
        transition: border-color 0.3s;
    }
    
    .chat-input-group input:focus {
        outline: none;
        border-color: #044f54;
    }
    
    .chat-input-group button {
        background: #044f54;
        color: white;
        border: none;
        padding: 12px 20px;
        border-radius: 8px;
        cursor: pointer;
        font-size: 14px;
        font-weight: 600;
        transition: background 0.3s;
    }
    
    .chat-input-group button:hover {
        background: #033a3f;
    }
    
    /* Hero Section - Compact */
    .hero-section {
        padding: 20px;
        text-align: center;
    }
    
    .hero-section h1 {
        font-size: clamp(1.75rem, 4vw, 2.5rem);
        font-weight: 700;
        margin: 0 0 20px 0;
        color: #000;
        line-height: 1.2;
    }
    
    .hero-text {
        max-width: 100%;
        margin: 0 auto;
        font-size: 15px;
        color: #4a4a4a;
        line-height: 1.6;
    }
    
    .hero-text p {
        margin: 0 0 8px 0;
    }
    
    /* Content Sections - Very Compact */
    .content-section {
        padding: 25px 20px;
        max-width: 100%;
    }
    
    .content-section h2 {
        font-size: clamp(1.5rem, 3vw, 2rem);
        font-weight: 700;
        margin: 0 0 12px 0;
        color: #000;
        line-height: 1.2;
    }
    
    .content-section h3 {
        font-size: clamp(1.1rem, 2.5vw, 1.4rem);
        font-weight: 700;
        margin: 25px 0 10px 0;
        color: #000;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .content-section p {
        margin: 0 0 10px 0;
        font-size: 15px;
        line-height: 1.6;
        color: #333;
    }
    
    .content-section strong {
        font-weight: 700;
        color: #000;
    }
    
    /* Highlight Box - Compact */
    .highlight-box {
        background: #f8f9fa;
        padding: 20px;
        border-radius: 8px;
        margin: 20px 0;
        border-left: 3px solid #044f54;
    }
    
    .highlight-box p {
        margin: 0 0 10px 0;
        font-size: 15px;
    }
    
    .highlight-box p:last-child {
        margin-bottom: 0;
    }
    
    /* CTA Section - Compact */
    .cta-section {
        text-align: center;
        padding: 30px 20px;
        background: #000;
        margin: 25px 0;
    }
    
    .cta-text {
        font-size: clamp(1.1rem, 2.5vw, 1.4rem);
        font-weight: 700;
        color: #fff;
        cursor: pointer;
        transition: opacity 0.3s;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }
    
    .cta-text:hover {
        opacity: 0.9;
    }
    
    .cta-text a {
        color: inherit;
        text-decoration: none;
    }
    
    /* Mobile Optimizations */
    @media (max-width: 768px) {
        .sales-page {
            max-width: 100%;
        }
        
        .chatbot-section {
            padding: 15px;
            margin-bottom: 20px;
        }
        
        .chat-messages {
            height: 300px;
            padding: 12px;
        }
        
        .hero-section {
            padding: 15px;
        }
        
        .content-section {
            padding: 20px 15px;
        }
        
        .highlight-box {
            padding: 15px;
            margin: 15px 0;
        }
        
        .cta-section {
            padding: 25px 15px;
            margin: 20px 0;
        }
        
        .chat-input-group {
            flex-direction: column;
        }
        
        .chat-input-group input {
            width: 100%;
        }
        
        .chat-input-group button {
            width: 100%;
        }
    }
    
    @media (max-width: 480px) {
        .chatbot-section {
            padding: 12px;
        }
        
        .chat-messages {
            height: 250px;
        }
        
        .hero-section {
            padding: 12px;
        }
        
        .content-section {
            padding: 15px 12px;
        }
        
        .highlight-box {
            padding: 12px;
        }
        
        .cta-section {
            padding: 20px 12px;
        }
    }
    
    /* Smooth Scrolling */
    html {
        scroll-behavior: smooth;
    }
    
    /* Custom Scrollbar */
    .chat-messages::-webkit-scrollbar {
        width: 4px;
    }
    
    .chat-messages::-webkit-scrollbar-track {
        background: #f1f1f1;
    }
    
    .chat-messages::-webkit-scrollbar-thumb {
        background: #ccc;
        border-radius: 2px;
    }
    
    .chat-messages::-webkit-scrollbar-thumb:hover {
        background: #999;
    }
</style>

<div class="sales-page">
    <!-- Chatbot Section - At Top -->
    <div class="chatbot-section" id="chatbot">
        <div class="chatbot-container">
            <div class="chatbot-header">
                <h3>Get Your Paradigm Profile</h3>
            </div>
            <div class="chat-messages" id="chat-messages">
                <div class="chat-message bot-message">
                    <div class="message-content">Hello! I am here to assist you in buying your Paradigm Profile, What is your <strong>First Name</strong>?</div>
                </div>
            </div>
            <div class="chat-input-area">
                <div class="chat-input-group">
                    <input type="text" id="user-input" placeholder="Type your answer..." />
                    <button id="send-btn">Send</button>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Hero Section -->
    <div class="hero-section">
        <h1>ParadigmProfiles.com</h1>
        <div class="hero-text">
            <p>We live in a world obsessed with shortcuts, the next "shiny object" promising instant success, the newest system that claims to fix you, or the "one-size-fits-all" formula that guarantees transformation. And yet… nothing truly sticks.</p>
            <p>Because you are not a formula. You are not broken. You are different by design.</p>
            <p>Real transformation doesn't come from chasing what's new, it comes from knowing what's true — about you.</p>
        </div>
    </div>
    
    <!-- Content Sections -->
    <div class="content-section">
        <h2>Personal Understanding</h2>
        <p>How do you receive, process, and react to the world around you? Every thought, word, and choice flows from your internal design, thats your Paradigm.</p>
        <div class="highlight-box">
            <p><strong>Fact:</strong> Your Paradigm is shaped by 7 elements, that influence how you think, feel, react and behave. They're constantly twisted, tuned, and gets influenced by life's impact moments, but they never truly change.</p>
            <p>You don't go to bed one evening and wake up someone totally new (we all know genies don't excites). Your preferences remain your preferences</p>
        </div>
        <h3>LET ME EXPLAIN</h3>
        <p>they simply evolve in expression as your awareness grows. Discovering your Paradigm helps you see the world differently, and suddenly, the world sees you differently too.</p>
    </div>
    
    <div class="content-section">
        <h2>Personal Acceptance</h2>
        <p>Self-acceptance is not about settling. It's about seeing yourself clearly, the gifts, the triggers, the growth zones, and embracing them without judgment. When you accept your true nature, you stop fighting yourself... and start leading yourself.</p>
    </div>
    
    <div class="content-section">
        <h2>Before You Can Grow, You Must Know</h2>
        <p>We all search for the one thing that will finally change our lives the new opportunity, course, or secret formula that promises transformation. But most of what we chase is built for the masses, not for you.</p>
        <p>Before you can truly grow or develop, you must first uncover your true preferences, your original settings beneath layers of habit, expectation, and circumstance. What is your default design, the way you naturally think, feel, and act when the world stops telling you who to be?</p>
        <p>Because until you know that, you'll keep upgrading tools that were never made for your system. Growth that lasts begins with understanding your unique Paradigm.</p>
    </div>
    
    <div class="content-section">
        <h2>Personal Development (Not Change)</h2>
        <p>You don't need to become someone new. You need to become more you. When you align your natural wiring with the right strategies, you unlock results that feel authentic, not forced.</p>
        <p>The Paradigm Profile™ gives you the map. Our certified practitioners, is like your personal mentor whom help you use it to design a better life, To elevate your health, wealth, and relationships.</p>
    </div>
    
    <div class="content-section">
        <h2>Personal Growth (Transformation)</h2>
        <p>When understanding meets action, growth begins. True transformation isn't a single moment, it's a continuous evolution. Imagine communicating without confusion, connecting without conflict, and creating relationships that feel easy and empowering. That's the power of living in alignment with your paradigm.</p>
        <p>Let's get real for a moment. Just like you instantly know how you like your eggs scrambled, sunny-side-up, over-easy, or as an omelet you have built-in preferences for how you think, feel, love, decide, and act.</p>
        <p>You don't have to guess your way through life. The Paradigm Profile™ brings clarity to your inner design, clarity to your thoughts, your reactions, and your direction, so you can start transforming your life through knowing, not guessing.</p>
        <p>You're not stuck. You've just never seen your profile.</p>
    </div>
    
    <!-- CTA Section -->
    <div class="cta-section">
        <div class="cta-text">
            <a href="#chatbot">GET CLARITY NOW - DO YOUR PROFILE</a>
        </div>
    </div>
</div>

@push('scripts')
<script>
    $(document).ready(function() {
        const steps = [
            { field: 'surname', question: "Great! What is your <strong>Surname</strong>?" },
            { field: 'gender', question: "Thanks. What is your <strong>Gender</strong>? (Male/Female/Other)" },
            { field: 'dob', question: "Please enter your <strong>Date of Birth</strong> (e.g., 1990-01-15 or 15/01/1990)." },
            { field: 'whatsapp', question: "What is your <strong>WhatsApp Number</strong>? (Enter full number with country code)" },
            { field: 'email', question: "Perfect! What is your <strong>Email Address</strong>?" },
        ];

        let currentStep = 0;
        let userData = {};
        let chatbotStarted = false;

        function addMessage(text, isUser = false) {
            try {
                const className = isUser ? 'user-message' : 'bot-message';
                const html = `
                    <div class="chat-message ${className}">
                        <div class="message-content">${text}</div>
                    </div>
                `;
                
                const chatMessages = $('#chat-messages');
                if (chatMessages.length > 0) {
                    chatMessages.append(html);
                    chatMessages.scrollTop(chatMessages[0].scrollHeight);
                } else {
                    console.error('Chat messages container not found when trying to add message');
                }
            } catch (error) {
                console.error('Error adding message:', error);
            }
        }

        // Validate and parse date of birth
        function parseDateOfBirth(input) {
            // Try YYYY-MM-DD format
            let dateMatch = input.match(/^(\d{4})-(\d{1,2})-(\d{1,2})$/);
            if (dateMatch) {
                return {
                    year: dateMatch[1],
                    month: dateMatch[2].padStart(2, '0'),
                    day: dateMatch[3].padStart(2, '0'),
                    formatted: `${dateMatch[1]}-${dateMatch[2].padStart(2, '0')}-${dateMatch[3].padStart(2, '0')}`
                };
            }
            
            // Try DD/MM/YYYY format
            dateMatch = input.match(/^(\d{1,2})\/(\d{1,2})\/(\d{4})$/);
            if (dateMatch) {
                return {
                    year: dateMatch[3],
                    month: dateMatch[2].padStart(2, '0'),
                    day: dateMatch[1].padStart(2, '0'),
                    formatted: `${dateMatch[3]}-${dateMatch[2].padStart(2, '0')}-${dateMatch[1].padStart(2, '0')}`
                };
            }
            
            // Try DD-MM-YYYY format
            dateMatch = input.match(/^(\d{1,2})-(\d{1,2})-(\d{4})$/);
            if (dateMatch) {
                return {
                    year: dateMatch[3],
                    month: dateMatch[2].padStart(2, '0'),
                    day: dateMatch[1].padStart(2, '0'),
                    formatted: `${dateMatch[3]}-${dateMatch[2].padStart(2, '0')}-${dateMatch[1].padStart(2, '0')}`
                };
            }
            
            return null;
        }

        // Validate date
        function isValidDate(year, month, day) {
            const date = new Date(year, month - 1, day);
            return date.getFullYear() == year && 
                   date.getMonth() == month - 1 && 
                   date.getDate() == day &&
                   year >= 1900 && 
                   year <= new Date().getFullYear();
        }

        let waitingForDobConfirmation = false;
        let waitingForEmailConfirmation = false;
        let waitingForPhoneConfirmation = false;

        // Check if email exists
        function checkEmailExists(email) {
            return $.ajax({
                url: '/api/user/check-unique',
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'Accept': 'application/json',
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: JSON.stringify({ email: email })
            }).then(function(response) {
                if (response && response.errors && response.errors.email) {
                    return { errors: { email: response.errors.email } };
                }
                return response;
            }).catch(function(xhr) {
                if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.errors) {
                    return xhr.responseJSON;
                }
                throw xhr;
            });
        }

        function processInput() {
            const input = $('#user-input').val().trim();
            if (!input) return;
            
            const whatsappStepIndex = steps.findIndex(s => s.field === 'whatsapp');
            const emailStepIndex = steps.findIndex(s => s.field === 'email');

            // Handle DOB confirmation
            if (waitingForDobConfirmation) {
                const lowerInput = input.toLowerCase();
                if (lowerInput === 'yes' || lowerInput === 'y') {
                    addMessage(input, true);
                    waitingForDobConfirmation = false;
                    setTimeout(() => {
                        addMessage(steps[currentStep].question, false);
                        $('#user-input').attr('type', 'text');
                        currentStep++;
                    }, 500);
                    $('#user-input').val('');
                    return;
                } else if (lowerInput === 'no' || lowerInput === 'n') {
                    addMessage(input, true);
                    waitingForDobConfirmation = false;
                    setTimeout(() => {
                        addMessage("No problem! Please enter your date of birth again (e.g., 1990-01-15 or 15/01/1990).", false);
                    }, 500);
                    $('#user-input').val('');
                    return;
                } else {
                    addMessage("Please type 'yes' to confirm or 'no' to re-enter.", false);
                    $('#user-input').val('');
                    return;
                }
            }

            // Handle Email confirmation
            if (waitingForEmailConfirmation) {
                const lowerInput = input.toLowerCase();
                if (lowerInput === 'yes' || lowerInput === 'y') {
                    addMessage(input, true);
                    waitingForEmailConfirmation = false;
                    userData['email_confirmed'] = true;
                    setTimeout(() => {
                        addMessage("Creating your account... please wait.", false);
                        registerUser();
                    }, 500);
                    $('#user-input').val('');
                    return;
                } else if (lowerInput === 'no' || lowerInput === 'n') {
                    addMessage(input, true);
                    waitingForEmailConfirmation = false;
                    currentStep = steps.findIndex(s => s.field === 'email');
                    delete userData['email'];
                    setTimeout(() => {
                        addMessage("No problem! Please enter your email address again.", false);
                    }, 500);
                    $('#user-input').val('');
                    return;
                } else {
                    addMessage("Please type 'yes' to confirm or 'no' to re-enter.", false);
                    $('#user-input').val('');
                    return;
                }
            }

            // Handle Phone confirmation
            if (waitingForPhoneConfirmation) {
                const lowerInput = input.toLowerCase();
                if (lowerInput === 'yes' || lowerInput === 'y') {
                    addMessage(input, true);
                    waitingForPhoneConfirmation = false;
                    userData['phone_confirmed'] = true;
                    const emailIndex = steps.findIndex(s => s.field === 'email');
                    const emailQuestion = emailIndex !== -1 ? steps[emailIndex].question : "Perfect! What is your <strong>Email Address</strong>?";
                    currentStep = emailIndex !== -1 ? emailIndex + 1 : steps.length;
                    setTimeout(() => {
                        addMessage(emailQuestion, false);
                    }, 500);
                    $('#user-input').val('');
                    return;
                } else if (lowerInput === 'no' || lowerInput === 'n') {
                    addMessage(input, true);
                    waitingForPhoneConfirmation = false;
                    currentStep = steps.findIndex(s => s.field === 'whatsapp');
                    delete userData['whatsapp'];
                    setTimeout(() => {
                        addMessage("No problem! Please enter your phone number again (Enter full number with country code).", false);
                    }, 500);
                    $('#user-input').val('');
                    return;
                } else {
                    addMessage("Please type 'yes' to confirm or 'no' to re-enter.", false);
                    $('#user-input').val('');
                    return;
                }
            }

            // Handle date of birth validation
            if (currentStep > 0 && steps[currentStep - 1].field === 'dob' && !waitingForDobConfirmation) {
                const parsedDate = parseDateOfBirth(input);
                if (!parsedDate) {
                    addMessage("Invalid date format. Please enter your date of birth (e.g., 1990-01-15 or 15/01/1990).", false);
                    return;
                }
                
                if (!isValidDate(parsedDate.year, parsedDate.month, parsedDate.day)) {
                    addMessage("Invalid date. Please enter a valid date of birth.", false);
                    return;
                }
                
                userData['dob'] = parsedDate.formatted;
                addMessage(input, true);
                waitingForDobConfirmation = true;
                setTimeout(() => {
                    addMessage(`I detected your date of birth as: <strong>${parsedDate.formatted}</strong>. Is this correct?`, false);
                    addMessage("Type 'yes' to confirm or 'no' to re-enter.", false);
                }, 500);
                
                $('#user-input').val('');
                return;
            }

            // Handle phone number input
            const isWhatsappStep = (currentStep > 0 && steps[currentStep - 1].field === 'whatsapp') || 
                                  (currentStep === whatsappStepIndex);
            
            if (isWhatsappStep && !waitingForPhoneConfirmation && !waitingForEmailConfirmation && !waitingForDobConfirmation && !userData['whatsapp']) {
                userData['whatsapp'] = input;
                addMessage(input, true);
                setTimeout(() => {
                    addMessage(`Please confirm your phone number: <strong>${input}</strong>`, false);
                    addMessage("Type 'yes' to confirm or 'no' to re-enter.", false);
                    waitingForPhoneConfirmation = true;
                }, 500);
                $('#user-input').val('');
                return;
            }
            
            // Handle email validation
            const isEmailStep = (currentStep === emailStepIndex) || 
                               (currentStep > 0 && steps[currentStep - 1] && steps[currentStep - 1].field === 'email');
            const isOnWhatsappStep = (currentStep === whatsappStepIndex) || 
                                    (currentStep > 0 && steps[currentStep - 1] && steps[currentStep - 1].field === 'whatsapp');
            
            const looksLikeEmail = /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(input);
            const shouldProcessEmail = (isEmailStep || (looksLikeEmail && !userData['email'] && userData['phone_confirmed'])) && 
                                      !isOnWhatsappStep && 
                                      !waitingForEmailConfirmation && 
                                      !waitingForDobConfirmation && 
                                      !waitingForPhoneConfirmation && 
                                      !userData['email'];
            
            if (shouldProcessEmail) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                if (!emailRegex.test(input)) {
                    addMessage("Please enter a valid email address.", false);
                    return;
                }
                
                addMessage(input, true);
                addMessage("Checking if this email is available...", false);
                
                checkEmailExists(input).then(function(response) {
                    if (response === false || (response.errors && response.errors.email)) {
                        addMessage("This email is already registered. Please use a different email address.", false);
                        $('#user-input').val('');
                    } else {
                        userData['email'] = input;
                        setTimeout(() => {
                            addMessage(`Please confirm your email address: <strong>${input}</strong>`, false);
                            addMessage("Type 'yes' to confirm or 'no' to re-enter.", false);
                            waitingForEmailConfirmation = true;
                        }, 500);
                        $('#user-input').val('');
                    }
                }).catch(function(error) {
                    console.error('Error checking email:', error);
                    userData['email'] = input;
                    setTimeout(() => {
                        addMessage(`Please confirm your email address: <strong>${input}</strong>`, false);
                        addMessage("Type 'yes' to confirm or 'no' to re-enter.", false);
                        waitingForEmailConfirmation = true;
                    }, 500);
                    $('#user-input').val('');
                });
                return;
            }

            // Display user message
            addMessage(input, true);
            $('#user-input').val('');

            // Store data
            const currentField = currentStep > 0 ? steps[currentStep - 1].field : null;
            if (currentStep === 0) {
                userData['first_name'] = input;
            } else if (currentField !== 'dob' && currentField !== 'email' && currentField !== 'whatsapp') {
                const field = currentField;
                userData[field] = input;
            }

            // Move to next step
            if (currentStep < steps.length && currentField !== 'email' && currentField !== 'whatsapp' && currentField !== 'dob') {
                setTimeout(() => {
                    addMessage(steps[currentStep].question, false);
                    $('#user-input').attr('type', 'text');
                    currentStep++;
                }, 500);
            }
        }

        function registerUser() {
            const missingFields = [];
            if (!userData['first_name']) missingFields.push('first name');
            if (!userData['surname']) missingFields.push('surname');
            if (!userData['whatsapp']) missingFields.push('phone number');
            if (!userData['email']) missingFields.push('email');

            if (missingFields.length > 0) {
                addMessage(`I still need your ${missingFields.join(', ')} before I can create your account. Please start again and provide the missing information.`, false);
                return;
            }
            
            const payload = {
                first_name: userData['first_name'],
                last_name: userData['surname'],
                email: userData['email'],
                phone_number: userData['whatsapp'],
                gender: userData['gender'] || null,
                dob: userData['dob'] || null,
            };

            $.ajax({
                url: '{{ route("paradigm.payment.chatbot-register") }}',
                method: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: payload,
                xhrFields: {
                    withCredentials: true
                },
                success: function(response) {
                    console.log('Registration response:', response);
                    const isSuccess = response?.code === 200 || response?.status === 200 || response?.status === 'success';
                    
                    if (isSuccess) {
                        addMessage("Account created successfully! Redirecting to purchase credits...", false);
                        setTimeout(() => {
                            window.location.href = "{{ route('user.paradigm.buy-credits') }}";
                        }, 1500);
                    } else {
                        const apiErrors = response?.errors ? Object.values(response.errors).flat().join(' ') : '';
                        addMessage("Registration failed: " + (apiErrors || response?.message || "Unknown error"), false);
                    }
                },
                error: function(xhr) {
                    console.error('Registration error:', xhr);
                    let errorMsg = "Registration failed.";
                    if (xhr.responseJSON && xhr.responseJSON.errors) {
                        errorMsg += " " + Object.values(xhr.responseJSON.errors).flat().join(' ');
                    } else if (xhr.responseJSON && xhr.responseJSON.message) {
                        errorMsg += " " + xhr.responseJSON.message;
                    }
                    addMessage(errorMsg, false);
                }
            });
        }

        chatbotStarted = true;
        
        setTimeout(function() {
            const chatMessages = $('#chat-messages');
            if (chatMessages.length > 0) {
                chatMessages.scrollTop(chatMessages[0].scrollHeight);
            }
        }, 100);

        $('#send-btn').click(processInput);
        $('#user-input').keypress(function(e) {
            if (e.which == 13) processInput();
        });

        $('a[href="#chatbot"]').click(function(e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: $('#chatbot').offset().top - 20
            }, 500);
            $('#user-input').focus();
        });
    });
</script>
@endpush
@endsection

