@extends('front')
@section('title', $data['seo_title'] ?? $companyName)
@section('description', $data['seo_description'] ?? $companyName)
@section('keywords', $data['seo_tag'] ?? $companyName)
@section('content')
    <!-- Content Wrapper with Background -->
    <div style="background-image: url('{{ asset('assets/img/homepage_bg.jpeg') }}?v={{ time() }}'); background-size: cover; background-position: center; background-repeat: no-repeat; background-attachment: fixed; min-height: 100vh; width: 100%;">
        
        <!-- Sign In Block - Centered on page -->
        @if (empty(Auth::id()))
        <style>
            /* Hide footer on homepage */
        footer {
            display: none !important;
        }

        /* Mobile specific styles for sign-in card */
            @media (max-width: 767.98px) {
                .index-signin-block {
                    top: 55% !important;
                    width: 90% !important;
                    max-width: 450px !important;
                }
                .signin-block-card {
                    padding: 1.25rem !important; /* Even less padding */
                    min-height: auto !important;
                    display: flex;
                    flex-direction: column;
                    justify-content: center;
                    background: rgba(255, 255, 255, 0.9) !important;
                    backdrop-filter: blur(5px);
                }
                .signin-block-card h3 {
                    font-size: 1.3rem !important;
                    margin-bottom: 0.15rem !important;
                }
                /* Show subtitle but with minimal margin */
                .signin-block-card p {
                    display: block !important;
                    font-size: 0.8rem !important;
                    margin-bottom: 0.25rem !important; /* Minimal margin */
                    line-height: 1.2;
                }
                /* Tight margins */
                .signin-block-card .mb-3 {
                    margin-bottom: 0.5rem !important;
                }
                .signin-block-card .mb-4 {
                    margin-bottom: 0.75rem !important; /* Reduced further */
                }
                /* Inputs */
                .signin-block-card .form-control, 
                .signin-block-card .btn {
                    padding: 0.5rem 0.75rem !important;
                    font-size: 0.95rem !important;
                    height: auto !important;
                }
                .signin-block-card .form-label {
                    font-size: 0.85rem !important;
                    margin-bottom: 0.15rem !important;
                }
                /* Adjust forgot password link */
                .signin-block-card .fs-14 {
                    font-size: 0.8rem !important;
                }
                /* Hide error message container if empty to save space */
                #hero_error_login_message:empty {
                    display: none;
                    margin-bottom: 0 !important;
                }
            }
            /* Desktop styles */
            @media (min-width: 768px) {
                .signin-block-card {
                    background: rgba(255, 255, 255, 0.95) !important;
                    box-shadow: 0 4px 20px rgba(0, 0, 0, 0.15);
                }
            }
        </style>

        <div class="index-signin-block" style="position: fixed; top: 50%; left: 50%; transform: translate(-50%, -50%); z-index: 1000 !important; width: 100%; max-width: 100%; pointer-events: none;">
            <div class="container" style="pointer-events: auto;">
                <div class="row justify-content-center">
                    <div class="col-12 col-md-8 col-lg-6 col-xl-5">
                        <div class="signin-block-card" style="border-radius: 12px; padding: 2rem;">
                            <div class="text-center mb-4">
                                <h3 class="mb-2" style="color: #044f54; font-weight: 700;">{{ __('Welcome') }}</h3>
                                <p style="color: #6b7280; margin-bottom: 0;">{{ __('Enter your credentials to access your account') }}</p>
                            </div>
                            <form id="hero-signin-form" autocomplete="off">
                                {{ csrf_field() }}
                                <div id="hero_error_login_message" class="text-danger text-center mb-3" style="min-height: 20px;"></div>
                                <div class="mb-3">
                                    <label class="form-label" style="color: #374151; font-weight: 600; margin-bottom: 0.5rem;">{{ __('Email') }}</label>
                                    <input type="text" name="email" class="form-control" placeholder="{{ __('Enter Email') }}" autocomplete="username" style="border: 1px solid #d1d5db; border-radius: 8px; padding: 0.75rem; background-color: #f9fafb;">
                                </div>
                                <div class="mb-4">
                                    <div class="d-flex align-items-center justify-content-between flex-wrap mb-1">
                                        <label class="form-label" style="color: #374151; font-weight: 600; margin-bottom: 0;">{{ __('Password') }}</label>
                                        <a href="#!" class="fw-medium text-decoration-underline fs-14" style="color: #044f54 !important; cursor: pointer; pointer-events: auto;" data-bs-toggle="modal" data-bs-target="#forgot-modal">{{ __('Forgot Password') }}</a>
                                    </div>
                                    <div class="input-group">
                                        <input type="password" name="password" id="hero_login_password" class="form-control" maxlength="100" placeholder="{{ __('Enter Password') }}" autocomplete="current-password" style="border: 1px solid #d1d5db; border-radius: 8px 0 0 8px; padding: 0.75rem; background-color: #f9fafb;">
                                        <button class="btn btn-outline-dark" type="button" id="heroLoginTogglePassword" tabindex="-1" style="border: 1px solid #d1d5db; border-left: none; border-radius: 0 8px 8px 0; background-color: #f9fafb;">
                                            <i class="fas fa-eye" id="heroToggleIcon"></i>
                                        </button>
                                    </div>
                                </div>
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-linear-primary" style="background-color: #044f54 !important; border-color: #044f54 !important; color: #ffffff !important; padding: 0.75rem; border-radius: 8px; font-weight: 600; font-size: 1rem;">
                                        {{ __('Sign In') }}
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @endif

        @if ($data['status'] == 1) <!-- Check if the page status is 1 -->
            @foreach ($content_sections as $section)
                @if (isset($section['section_type'], $section['status']) && $section['status'] == 1)
                    @if ($section['section_type'] === 'banner')
                        @include('partials.hero-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'category')
                        @include('partials.category-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'featured_service')
                        @include('partials.service-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'popular_service')
                        @include('partials.popular-section', ['popularSection' => $section])
                    @elseif ($section['section_type'] === 'how_it_works')
                        @include('partials.how-it-work-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'service')
                        @include('partials.preferred-services-section')
                    @elseif ($section['section_type'] === 'popular_provider')
                        @include('partials.popular_provider_section', ['section' => $section])
                    @elseif ($section['section_type'] === 'rated_service')
                        @include('partials.rated_section', ['ratedSection' => $section])
                    @elseif ($section['section_type'] === 'testimonial')
                        @include('partials.testimonial-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'become_provider')
                        @include('partials.provider-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'blog')
                        @include('partials.blog-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'business_with_us')
                        @include('partials.business-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'link')
                        @include('partials.link-section')
                    @elseif ($section['section_type'] === 'about_us')
                        @include('partials.about-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'contact_us')
                        @include('partials.contact-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'terms_conditions')
                        @include('partials.terms-condition-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'privacy_policy')
                        @include('partials.privacy-policy-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'advertisement')
                        @include('partials.advertisement-section')
                    @elseif ($section['section_type'] === 'multiple_section')
                        @include('partials.multiple-section', ['section' => $section])
                    @elseif ($section['section_type'] === 'faq')
                        @include('partials.faq-section', ['section' => $section])
                    @endif
                @endif
            @endforeach
        @endif
    </div>

    <!-- Sign In Form JavaScript -->
    @if (empty(Auth::id()))
    <style>
        /* Ensure forgot password modal appears above sign-in form */
        #forgot-modal {
            z-index: 10050 !important;
        }
        #forgot-modal .modal-backdrop {
            z-index: 10000 !important;
        }
        /* Ensure forgot password link is visible and clickable */
        .index-signin-block a[data-bs-target="#forgot-modal"] {
            display: inline-block !important;
            visibility: visible !important;
            opacity: 1 !important;
            pointer-events: auto !important;
        }
    </style>
    <script>
        // Wait for jQuery to be loaded
        (function() {
            function initHomepageScripts() {
                if (typeof jQuery === 'undefined' || typeof $ === 'undefined') {
                    setTimeout(initHomepageScripts, 100);
                    return;
                }
                
                $(document).ready(function() {
                    // Password toggle for hero form
                    $("#heroLoginTogglePassword").on("click", function() {
                        const passwordField = $("#hero_login_password");
                        const toggleIcon = $("#heroToggleIcon");
                        const isPassword = passwordField.attr("type") === "password";
                        passwordField.attr("type", isPassword ? "text" : "password");
                        toggleIcon.toggleClass("fa-eye fa-eye-slash");
                    });

                    // Hero sign-in form validation and submission
                    $("#hero-signin-form").validate({
                        rules: {
                            email: {
                                required: true,
                                email: true,
                            },
                            password: {
                                required: true,
                                minlength: 8,
                            },
                        },
                        messages: {
                            email: {
                                required: "The email field is required.",
                                email: "Please enter a valid email address.",
                            },
                            password: {
                                required: "The password field is required.",
                                minlength: "The password must be at least 8 characters.",
                            },
                        },
                        errorElement: "span",
                        errorPlacement: function (error, element) {
                            error.addClass("invalid-feedback");
                            element.closest(".mb-3").append(error);
                        },
                        highlight: function (element) {
                            $(element).addClass("is-invalid").removeClass("is-valid");
                        },
                        unhighlight: function (element) {
                            $(element).removeClass("is-invalid").addClass("is-valid");
                        },
                        submitHandler: function (form) {
                            var formData = new FormData(form);
                            var submitBtn = $(form).find('button[type="submit"]');
                            var originalText = submitBtn.html();

                            $.ajax({
                                url: "/userlogins",
                                method: "POST",
                                data: formData,
                                dataType: "json",
                                contentType: false,
                                processData: false,
                                cache: false,
                                beforeSend: function () {
                                    submitBtn.attr("disabled", true);
                                    submitBtn.html("<div class='spinner-border spinner-border-sm text-light' role='status'></div> Signing in...");
                                },
                            })
                            .done((response) => {
                                $("#hero_error_login_message").text("");
                                $("#hero-signin-form .form-control").removeClass("is-invalid");
                                submitBtn.removeAttr("disabled");
                                submitBtn.html(originalText);
                                if (response.code === 200) {
                                    if (response.provider_verified_status == 0) {
                                        if (response.next_step === 'id_verification') {
                                            window.location.href = response.redirect_url;
                                        } else {
                                            $("#provider_not_verified_modal").modal("show");
                                        }
                                    } else {
                                        $("#success_modal").modal("show");
                                        setTimeout(function () {
                                            window.location.href = response.redirect_url;
                                        }, 500);
                                    }
                                }
                            })
                            .fail((error) => {
                                $("#hero_error_login_message").text("");
                                $("#hero-signin-form .form-control").removeClass("is-invalid");
                                submitBtn.removeAttr("disabled");
                                submitBtn.html(originalText);

                                if (error.status === 422) {
                                    if (error.responseJSON.errors) {
                                        $.each(error.responseJSON.errors, function (key, val) {
                                            $("#hero-signin-form [name='" + key + "']").addClass("is-invalid");
                                            $("#hero-signin-form [name='" + key + "']").closest(".mb-3").find(".invalid-feedback").text(val[0]);
                                        });
                                    }
                                    if (error.responseJSON.message) {
                                        $("#hero_error_login_message").text(error.responseJSON.message);
                                    }
                                } else {
                                    $("#hero_error_login_message").text(error.responseJSON?.message || "An unexpected error occurred.");
                                }
                            });
                        },
                    });
                });
            }
            initHomepageScripts();
        })();
    </script>
    @endif
@endsection
