@extends('front')

@section('title', 'Paradigm Assessment Form')

@section('content')
<style>
    body {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        min-height: 100vh;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .preview-container {
        padding: 2rem 0;
    }
    .form-card {
        background: white;
        border-radius: 15px;
        box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        overflow: hidden;
        max-width: 800px;
        margin: 0 auto;
    }
    .form-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
        padding: 2rem;
        text-align: center;
    }
    .form-header h1 {
        margin: 0;
        font-size: 2rem;
        font-weight: 600;
    }
    .form-body {
        padding: 2rem;
    }
    .section-title {
        color: #333;
        border-bottom: 2px solid #667eea;
        padding-bottom: 0.5rem;
        margin-bottom: 1.5rem;
        font-weight: 600;
    }
    .progress-bar {
        width: 100%;
        height: 8px;
        background: #e9ecef;
        border-radius: 4px;
        overflow: hidden;
        margin-bottom: 1rem;
    }
    .progress-fill {
        height: 100%;
        background: linear-gradient(90deg, #667eea, #764ba2);
        width: 0%;
        transition: width 0.3s ease;
    }
    .question-item {
        margin-bottom: 2rem;
        padding: 1.5rem;
        border: 1px solid #e9ecef;
        border-radius: 10px;
        background: #f8f9fa;
    }
    .question-text {
        font-size: 1.1rem;
        font-weight: 500;
        margin-bottom: 1rem;
        color: #333;
    }
    .options-container {
        display: flex;
        flex-direction: column;
        gap: 0.75rem;
    }
    .option-item {
        display: flex;
        align-items: center;
        padding: 0.75rem;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        cursor: pointer;
        transition: all 0.2s ease;
    }
    .option-item:hover {
        border-color: #667eea;
        background: #f0f2ff;
    }
    .option-input {
        margin-right: 0.75rem;
    }
    .option-label {
        margin: 0;
        cursor: pointer;
        flex: 1;
    }
    .btn-primary {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        border: none;
        padding: 0.75rem 2rem;
        font-weight: 600;
        border-radius: 8px;
    }
    .btn-primary:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 20px rgba(102, 126, 234, 0.3);
    }
    .personality-result {
        display: none;
        text-align: center;
        padding: 2rem;
        background: #f8f9fa;
        border-radius: 10px;
        margin-top: 2rem;
    }
    .personality-type {
        font-size: 1.5rem;
        font-weight: 600;
        color: #667eea;
        margin-bottom: 1rem;
    }
    .personality-description {
        color: #666;
        line-height: 1.6;
    }
</style>

<div class="container">
    {!! $content !!}
</div>
@endsection
