<!-- Request Help Form (Marketplace Lead Form) -->
<div class="request-help-form-wrapper" style="position: relative; z-index: 100;">
    <div class="request-help-form card shadow-lg">
        <div class="card-header text-white" style="background: #044f54;">
            <h4 class="mb-1 text-white">{{ __('Need Help?') }}</h4>
            <p class="mb-0 small text-white opacity-90">{{ __('Fill the form below and providers will contact you') }}</p>
        </div>
        
        <div class="card-body p-4">
            <!-- Progress Indicator -->
            <div class="progress-steps mb-4 d-flex justify-content-between position-relative">
                <div class="step active" data-step="1">
                    <span class="step-number">1</span>
                    <span class="step-label d-none d-md-inline">{{ __('Service') }}</span>
                </div>
                <div class="step" data-step="2">
                    <span class="step-number">2</span>
                    <span class="step-label d-none d-md-inline">{{ __('Questions') }}</span>
                </div>
                <div class="step" data-step="3">
                    <span class="step-number">3</span>
                    <span class="step-label d-none d-md-inline">{{ __('Message') }}</span>
                </div>
                <div class="step" data-step="4" id="registration-step-indicator" style="display: none;">
                    <span class="step-number">4</span>
                    <span class="step-label d-none d-md-inline">{{ __('Register') }}</span>
                </div>
            </div>

            <!-- Form Steps -->
            <form id="requestHelpForm" class="multi-step-form">
                
                <!-- STEP 1: Category & Service -->
                <div class="form-step active" data-step="1">
                    <h5 class="mb-3">{{ __('What service do you need?') }}</h5>
                    
                    <div class="mb-3">
                        <label for="rh_category_id" class="form-label">{{ __('Select Category') }} *</label>
                        <select class="form-select" id="rh_category_id" name="category_id" required>
                            <option value="">{{ __('Choose a category...') }}</option>
                            <!-- Loaded dynamically via JavaScript -->
                        </select>
                        <div class="invalid-feedback">{{ __('Please select a category') }}</div>
                    </div>

                    <div class="mb-3">
                        <label for="rh_service_id" class="form-label">{{ __('Select Service') }} ({{ __('Optional') }})</label>
                        <select class="form-select" id="rh_service_id" name="service_id">
                            <option value="">{{ __('Choose a service...') }}</option>
                            <!-- Loaded dynamically when category selected -->
                        </select>
                        <small class="text-muted">{{ __('Select a category first to see available services') }}</small>
                    </div>

                    <div class="d-flex justify-content-end">
                        <button type="button" class="btn btn-primary btn-next">{{ __('Next') }} →</button>
                    </div>
                </div>

                <!-- STEP 2: Dynamic Questions -->
                <div class="form-step" data-step="2" style="display: none;">
                    <h5 class="mb-3">{{ __('Quick Questions') }}</h5>
                    <p class="text-muted mb-4">{{ __('Help us understand your needs better by answering a few questions') }}</p>
                    
                    <div id="dynamic_questions_container">
                        <div class="text-center py-4">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">{{ __('Loading...') }}</span>
                            </div>
                            <p class="text-muted mt-2">{{ __('Loading questions...') }}</p>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between mt-4">
                        <button type="button" class="btn btn-secondary btn-prev">← {{ __('Back') }}</button>
                        <button type="button" class="btn btn-primary btn-next">{{ __('Next') }} →</button>
                    </div>
                </div>



                <!-- STEP 3: Message -->
                <div class="form-step" data-step="3" style="display: none;">
                    <h5 class="mb-3">{{ __('Describe Your Needs') }}</h5>
                    
                    <div class="mb-3">
                        <label for="rh_message_text" class="form-label">{{ __('Tell us what you need help with') }} *</label>
                        <textarea class="form-control" id="rh_message_text" name="message_text" rows="8" 
                                  placeholder="{{ __('Be specific - providers will see this after unlock') }}" 
                                  minlength="50" maxlength="2000" required></textarea>
                        <div class="d-flex justify-content-between mt-2">
                            <small class="text-muted">{{ __('Minimum 50 characters') }}</small>
                            <small id="rh_char_counter" class="text-muted">0 / 2000</small>
                        </div>
                        <div class="invalid-feedback">{{ __('Please provide at least 50 characters describing your needs') }}</div>
                    </div>

                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary btn-prev">← {{ __('Back') }}</button>
                        <button type="button" class="btn btn-primary btn-next">{{ __('Next') }} →</button>
                    </div>
                </div>

                <!-- STEP 4: Submit (For Logged-in Users) -->
                <div class="form-step" data-step="4" style="display: none;" id="submit-step">
                    <h5 class="mb-3">{{ __('Review & Submit') }}</h5>
                    <p class="text-muted mb-4">{{ __('Review your request and submit to connect with providers') }}</p>
                    
                    <div class="alert alert-info">
                        <i class="ri-information-line me-2"></i>
                        {{ __('Your request will be visible to providers who can help you.') }}
                    </div>

                    <div class="d-flex justify-content-between">
                        <button type="button" class="btn btn-secondary btn-prev">← {{ __('Back') }}</button>
                        <button type="submit" class="btn btn-success btn-lg" id="btn_submit_request_help">
                            <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            <span class="btn-text">{{ __('Submit Request') }}</span>
                        </button>
                    </div>
                </div>

                <!-- STEP 4: Registration (Only for Non-Logged Users) -->
                <div class="form-step" data-step="4" style="display: none;" id="registration-step">
                    <h5 class="mb-3">{{ __('Create Account to Submit Request') }}</h5>
                    <p class="text-muted mb-4">{{ __('We need your details to connect you with providers') }}</p>
                    
                    <!-- Registration fields will be loaded here dynamically -->
                    <div id="help_form_registration_container">
                        <div class="text-center py-4">
                            <div class="spinner-border text-primary" role="status">
                                <span class="visually-hidden">{{ __('Loading...') }}</span>
                            </div>
                            <p class="text-muted mt-2">{{ __('Loading registration form...') }}</p>
                        </div>
                    </div>

                    <div class="d-flex justify-content-between mt-4">
                        <button type="button" class="btn btn-secondary btn-prev">← {{ __('Back') }}</button>
                        <button type="submit" class="btn btn-success btn-lg" id="btn_submit_with_registration">
                            <span class="spinner-border spinner-border-sm d-none" role="status"></span>
                            <span class="btn-text">{{ __('Create Account & Submit') }}</span>
                        </button>
                    </div>
                </div>

            </form>
        </div>
    </div>
</div>

<style>
/* Request Help Form Styling */
.request-help-form-wrapper {
    padding: 2rem 0;
}

.request-help-form .card-header {
    padding: 1.5rem;
}

.progress-steps {
    padding: 0;
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    width: 100%;
}

/* Remove the line connecting progress steps */
.progress-steps::before {
    display: none !important;
}

.progress-steps .step {
    position: relative;
    z-index: 1;
    text-align: center;
    flex: 1;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: flex-start;
    min-width: 0;
}

.progress-steps .step-number {
    display: flex;
    align-items: center;
    justify-content: center;
    width: 40px;
    height: 40px;
    border-radius: 50%;
    background: #fff;
    border: 2px solid #e0e0e0;
    color: #999;
    font-weight: 600;
    transition: all 0.3s ease;
    margin: 0 auto;
    flex-shrink: 0;
}

.progress-steps .step.active .step-number {
    background: #044f54;
    border-color: #044f54;
    color: #fff;
}

.progress-steps .step.completed .step-number {
    background: #28a745;
    border-color: #28a745;
    color: #fff;
}

.progress-steps .step-label {
    display: block;
    font-size: 0.75rem;
    margin-top: 0.5rem;
    color: #999;
    text-align: center;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
    max-width: 100%;
}

.progress-steps .step.active .step-label {
    color: #044f54;
    font-weight: 600;
}

.request-help-form .btn-primary {
    background-color: #044f54 !important;
    border-color: #044f54 !important;
    color: white !important;
}

.request-help-form .btn-primary:hover {
    background-color: #033a3e !important;
    border-color: #033a3e !important;
    color: white !important;
}

.request-help-form .btn-secondary {
    background-color: #044f54 !important;
    border-color: #044f54 !important;
    color: white !important;
}

.request-help-form .btn-secondary:hover {
    background-color: #033a3e !important;
    border-color: #033a3e !important;
    color: white !important;
}

.form-step {
    animation: fadeIn 0.3s ease-in;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.review-summary .summary-item {
    border-bottom: 1px solid #e0e0e0;
    padding-bottom: 0.5rem;
}

.review-summary .summary-item:last-child {
    border-bottom: none;
}

#btn_submit_request_help .spinner-border {
    width: 1rem;
    height: 1rem;
    margin-right: 0.5rem;
}


/* Copy EXACT CSS from register form for phone element */
.request-help-form #rh_phone_number {
    padding-left: 120px !important;
}

.request-help-form .iti__selected-flag {
    width: 115px !important;
    min-width: 115px !important;
    max-width: 115px !important;
}

.request-help-form .iti__flag-container {
    width: 115px !important;
}

.request-help-form .iti {
    width: 100% !important;
}

.request-help-form .iti input[type="tel"] {
    padding-left: 120px !important;
    width: 100% !important;
}

@media (max-width: 768px) {
    .request-help-form {
        margin: 0 1rem;
    }
    
    .progress-steps .step-label {
        display: none !important;
    }
    
    .progress-steps .step-number {
        width: 32px;
        height: 32px;
        font-size: 0.875rem;
    }
}

</style>

<!-- Help Form Dedicated OTP Modal (Separate from Join Us) -->
<div class="modal fade" id="help-form-otp-modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header d-flex align-items-center justify-content-end pb-0 border-0">
                <a href="#!" data-bs-dismiss="modal" aria-label="Close"><i
                        class="ti ti-circle-x-filled fs-20"></i></a>
            </div>
            <div class="modal-body p-4">
                <form action="#" class="digit-group">
                    <div class="text-center mb-3">
                        <h3 class="mb-2">{{ __('Phone OTP Verification') }}</h3>
                        <p id="help-form-otp-message" class="fs-14">{{ __('OTP sent to your mobile number') }}</p>
                    </div>
                    <div class="text-center otp-input">
                        <div class="helpFormOtpContainer">
                            <!-- OTP inputs will be dynamically generated here -->
                        </div>
                        <span id="help-form-otp-error" class="text-danger"></span>
                        <div>
                            <div class="badge bg-danger-transparent mb-3">
                                <p class="d-flex align-items-center "><i class="ti ti-clock me-1"></i><span
                                        id="help-form-otp-timer">00:00</span></p>
                            </div>
                            <div class="mb-3 d-flex justify-content-center">
                                <p>{{ __('Didn t get the OTP?') }} <a href="#!"
                                        class="helpFormResendOtp text-primary">{{ __('Resend OTP') }}</a></p>
                            </div>
                            <div>
                                <button type="button" id="help-form-verify-otp-btn"
                                    class="btn btn-lg btn-linear-primary w-100">{{ __('Verify & Proceed') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>

