<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Redirecting to PayFast...</title>
    <style>
        body {
            font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, 'Helvetica Neue', Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #044f54 0%, #066a70 100%);
            color: white;
        }
        .loading-container {
            text-align: center;
            background: rgba(255, 255, 255, 0.1);
            padding: 40px;
            border-radius: 12px;
            backdrop-filter: blur(10px);
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
        }
        .spinner {
            border: 4px solid rgba(255, 255, 255, 0.3);
            border-top: 4px solid #ffffff;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin: 0 auto 20px;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        h3 {
            margin: 0 0 10px 0;
            font-weight: 600;
            font-size: 24px;
        }
        p {
            margin: 0;
            opacity: 0.9;
            font-size: 16px;
        }
        .secure-badge {
            margin-top: 20px;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
            font-size: 14px;
            opacity: 0.8;
        }
        .lock-icon {
            font-size: 18px;
        }
    </style>
</head>
<body>
    <div class="loading-container">
        <div class="spinner"></div>
        <h3>Redirecting to PayFast...</h3>
        <p>Please wait while we redirect you to the secure payment page.</p>
        <div class="secure-badge">
            <span class="lock-icon">🔒</span>
            <span>Secure Payment Gateway</span>
        </div>
    </div>
    
    <form id="payfast_form" action="{{ $action_url }}" method="POST" style="display: none;">
        @foreach($payment_data as $key => $value)
            <input type="hidden" name="{{ $key }}" value="{{ $value }}">
        @endforeach
    </form>
    
    <script>
        // Auto-submit form after a brief moment
        setTimeout(function() {
            document.getElementById('payfast_form').submit();
        }, 1000);
    </script>
</body>
</html>

