@php
    $a4WidthPt = 595.28;
    $a4HeightPt = 841.89;

    $xPos = ($element['x_pct'] / 100) * $a4WidthPt;
    $yPos = ($element['y_pct'] / 100) * $a4HeightPt;
    $width = ($element['w_pct'] / 100) * $a4WidthPt;
    $height = ($element['h_pct'] / 100) * $a4HeightPt;
    
    $category = $data['si_category'] ?? 'low';
@endphp

<div style="position: absolute; left: {{ $xPos }}pt; top: {{ $yPos }}pt; width: {{ $width }}pt; height: {{ $height }}pt; font-size: {{ $element['font_px'] }}px; color: {{ $element['color'] }}; display: flex; flex-direction: column; gap: 4pt;">
    <div style="display: flex; align-items: center;">
        <span style="width: 14pt; height: 14pt; border: 1pt solid #000; display: inline-flex; align-items: center; justify-content: center; margin-right: 4pt; background-color: {{ $category === 'low' ? '#ff0000' : '#fff' }};"></span>
        <span>Low</span>
    </div>
    <div style="display: flex; align-items: center;">
        <span style="width: 14pt; height: 14pt; border: 1pt solid #000; display: inline-flex; align-items: center; justify-content: center; margin-right: 4pt; background-color: {{ $category === 'medium' ? '#ff0000' : '#fff' }};"></span>
        <span>Medium</span>
    </div>
    <div style="display: flex; align-items: center;">
        <span style="width: 14pt; height: 14pt; border: 1pt solid #000; display: inline-flex; align-items: center; justify-content: center; margin-right: 4pt; background-color: {{ $category === 'high' ? '#ff0000' : '#fff' }};"></span>
        <span>High</span>
    </div>
</div>

