<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>{{ $template->name }}</title>
    <style>
        @page {
            margin: 0; /* Remove default margins */
        }
        body {
            font-family: 'Helvetica', 'Arial', sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        .page-container {
            width: 210mm;
            height: 297mm;
            position: relative;
            page-break-after: always;
            overflow: hidden;
        }
        .page-container:last-child {
            page-break-after: auto;
        }
        .background-image {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            z-index: -1;
        }
    </style>
</head>
<body>
    @foreach($processed_pages as $page)
        <div class="page-container">
            @if(!empty($page['background_image']))
                <img src="{{ $page['background_image'] }}" class="background-image" alt="Background">
            @endif

            @foreach(collect($page['pdf_elements'])->sortBy('display_order') as $element)
                @php
                    $viewPath = 'pdfs.elements.' . $element['element_type'];
                @endphp

                @if(View::exists($viewPath))
                    @include($viewPath, ['element' => $element, 'data' => $data])
                @else
                    <!-- Fallback for missing element partials -->
                    <div style="
                        position: absolute;
                        left: {{ $element['x_pct'] }}%;
                        top: {{ $element['y_pct'] }}%;
                        width: {{ $element['w_pct'] }}%;
                        height: {{ $element['h_pct'] }}%;
                        font-size: {{ $element['font_px'] }}px;
                        color: red;
                        border: 1px solid red;
                        overflow: hidden;
                        word-wrap: break-word;
                    ">
                        Missing view: {{ $element['element_type'] }}
                    </div>
                @endif
            @endforeach
        </div>
    @endforeach
</body>
</html>
