@extends('admin.admin')
@section('content')
	<div class="page-wrapper">
		<div class="content">
			<div class="row">
				<div class="col-md-12">
					<div class="d-md-flex d-block align-items-center justify-content-between mb-3">
						<div class="my-auto mb-2">
							<h3 class="page-title mb-1">   {{ $data['userlist'][0]->user_type == 2 ? __('Provider') : __('user') }} {{ __('Details')}}</h3>
							<nav>
								<ol class="breadcrumb mb-0">
									<li class="breadcrumb-item">
										<a href="{{route('admin.dashboard')}}">{{ __('Dashboard')}}</a>
									</li>
									<li class="breadcrumb-item">
										@if($data['userlist'][0]->user_type == 2)	
											<a href="{{route('admin.providerslist')}}">   {{ __('Provider') }}</a>
										@else
											<a href="{{route('admin.userlist')}}">   {{ __('user') }}</a>
										@endif
										</li>
									<li class="breadcrumb-item active" aria-current="page">   {{ $data['userlist'][0]->user_type == 2 ? __('Provider') : __('user') }} {{ __('Details')}}</li>
								</ol>
							</nav>
						</div>
						<div class="d-flex my-xl-auto right-content align-items-center  flex-wrap">	
							@if($data['userlist'][0]->user_type == 2)	
								<a href="{{route('admin.providerslist')}}" class="custom-btn-close d-flex align-items-center justify-content-center"  aria-label="Close">
								<i class="ti ti-x"></i></a>	
							@else
							<a href="{{route('admin.userlist')}}" class=" custom-btn-close d-flex align-items-center justify-content-center"  aria-label="Close">
							<i class="ti ti-x"></i></a>	
							@endif
						</div>
					</div>
				</div>
			</div>

			<!-- Complete Profile Header Section -->
			<div class="row mb-4">
				<div class="col-12">
					<div class="card border-white">
						<div class="card-body">
							<!-- Profile Picture and Basic Info Row -->
							<div class="row align-items-center">
								<div class="col-md-3 text-center">
									<div class="provider-image mx-auto mb-3">
										@if(!empty($data['userlist'][0]['userDetails']) && !empty($data['userlist'][0]['userDetails']->profile_image) && file_exists(public_path('storage/profile/' . $data['userlist'][0]['userDetails']->profile_image)))
										<img src="{{ asset('storage/profile/' . $data['userlist'][0]['userDetails']->profile_image) }}" alt="User Profile Image" class="img-fluid profileImagePreview" style="width: 120px; height: 150px; object-fit: cover; border: 2px solid #e5e7eb; border-radius: 8px;">
											@else
												<img src="{{ asset('assets/img/profile-default.png') }}" alt="Default Profile Image" class="img-fluid profileImagePreview" style="width: 120px; height: 150px; object-fit: cover; border: 2px solid #e5e7eb; border-radius: 8px;">
											@endif
									</div>
									
									<!-- Status and Verification -->
									<div class="mb-2">
										@if($data['userlist'][0]->status==1)
										    <span class="badge badge-soft-success d-inline-flex align-items-center mb-1"><i class="ti ti-circle-filled fs-5 me-1"></i>{{ __('Active') }}</span>
										@else
										    <span class="badge badge-soft-danger d-inline-flex align-items-center mb-1"><i class="ti ti-circle-filled fs-5 me-1"></i>{{ __('Inactive') }}</span>
	                                    @endif
									@if ($data['userlist'][0]->user_type == 2)
										@if($data['userlist'][0]->provider_verified_status == 1)
											<span class="badge bg-success ms-2">{{ __('verified') }}</span>
										@else
											@php
												$canVerify = true;
												$verifyMessage = '';
												// Check if ID verification is enabled and if documents are submitted
												if (providerIdVerificationEnabled()) {
													$verification = $data['userlist'][0]->identityVerification;
													if (!$verification || !$verification->submitted_at) {
														$canVerify = false;
														$verifyMessage = 'Provider must complete identity verification first';
													}
												}
											@endphp
											@if($canVerify)
												<button type="button" class="btn btn-sm btn-primary ms-2" data-bs-toggle="modal" data-bs-target="#verifyProviderModal">
													{{ __('verify') }}
												</button>
											@else
												<button type="button" class="btn btn-sm btn-secondary ms-2" disabled title="{{ $verifyMessage }}">
													<i class="ti ti-lock me-1"></i>{{ __('verify') }}
												</button>
												<small class="text-danger d-block mt-1">{{ $verifyMessage }}</small>
											@endif
										@endif
									@endif
									</div>
									
									<!-- Name and Email -->
									<h5 class="mb-1">
										{{$data['userlist'][0]['userDetails']->first_name ? $data['userlist'][0]['userDetails']->first_name . ' ' . $data['userlist'][0]['userDetails']->last_name : '  -'}}
									</h5>
									<p class="text-primary mb-0">{{$data['userlist'][0]->email ?? '  -'}}</p>
								</div>
								
								<!-- Basic Information -->
								<div class="col-md-5">
									<h5 class="mb-3">{{ __('Basic Information') }}</h5>
									<dl class="row mb-0"> 
										<dt class="col-6 fw-medium text-dark mb-3">{{ __('name')}}</dt> 
										<dd class="col-6 mb-3">{{$data['userlist'][0]['userDetails']->first_name ? $data['userlist'][0]['userDetails']->first_name . ' ' . $data['userlist'][0]['userDetails']->last_name : '  -'}}</dd> 
										<dt class="col-6 fw-medium text-dark mb-3">{{ __('gender')}}</dt> 
										<dd class="col-6 mb-3">{{$data['userlist'][0]['userDetails']->gender ?? '  -'}}</dd> 
										<dt class="col-6 fw-medium text-dark mb-3">{{ __('date_of_birth')}}</dt> 
										<dd class="col-6 mb-3">@if(!empty($data['userlist'][0]['userDetails']->dob))
											{{ \Carbon\Carbon::parse($data['userlist'][0]['userDetails']->dob)->format($data['DateFormat'] ?? 'd-m-Y') }}
										@else
											-
										@endif</dd> 
									</dl>
								</div>
								
								<!-- Primary Contact Info -->
								<div class="col-md-4">
									<h5 class="mb-3">{{ __('Primary Contact Info')}}</h5>
									<div class="d-flex align-items-center mb-3">
										<span class="avatar avatar-md bg-light-300 rounded me-2 flex-shrink-0 text-default"><i class="ti ti-phone"></i></span>
										<div>
											<span class="text-dark fw-medium mb-1">{{ __('phone_number')}}</span>
											<p>{{$data['userlist'][0]->phone_number ?? '   -'}}</p>
										</div>
									</div>
									<div class="d-flex align-items-center">
										<span class="avatar avatar-md bg-light-300 rounded me-2 flex-shrink-0 text-default"><i class="ti ti-mail"></i></span>
										<div>
											<span class="text-dark fw-medium mb-1">{{ __('Email Address')}}</span>
											<p>{{$data['userlist'][0]->email ?? '  -'}}</p>
										</div>
									</div>
								</div>
							</div>
							</div>
						</div>
					</div>
				</div>
			</div>

			<!-- Main Content Area -->
			<div class="row">
				<div class="col-12">
					<div class="row">
						<div class="col-md-12">

							<ul class="nav nav-tabs nav-tabs-bottom mb-4">
								<li>
									<a href="#" class="nav-link active"><i class="ti ti-user me-2"></i>   {{ $data['userlist'][0]->user_type == 2 ? __('Provider') : __('user') }} {{ __('Details')}}</a>
								</li>
							</ul>

							@if($data['userlist'][0]->user_type == 2)	
							<!-- Provider Bio Section -->
							<div class="card mb-4">
								<div class="card-header">
									<h5><i class="ti ti-user-circle me-2"></i>{{ __('Provider Bio') }}</h5>
								</div>
								<div class="card-body">
									@if(!empty($data['userlist'][0]['userDetails']->bio))
										<div class="bg-light-100 p-3 rounded">
											<p class="mb-0 text-dark">{{ $data['userlist'][0]['userDetails']->bio }}</p>
										</div>
									@else
										<div class="text-center text-muted py-4">
											<i class="ti ti-file-text fs-48 mb-3"></i>
											<p class="mb-0">{{ __('No bio provided') }}</p>
										</div>
									@endif
								</div>
							</div>

							<!-- Category Information -->
							<div class="card mb-4">
								<div class="card-header">
									<h5><i class="ti ti-category me-2"></i>{{ __('Category Information')}}</h5>
								</div>
								<div class="card-body">
									<div class="row">
										<!-- Main Category -->
										<div class="col-md-6 mb-3">
											<h6 class="text-dark fw-medium mb-3">{{ __('Main Category') }}</h6>
											<div class="d-flex align-items-center">
												<div class="provider-image flex-shrink-0 me-3">
													@if (!empty($data['userlist'][0]['userDetails']['category']->image) && file_exists(public_path('storage/' . $data['userlist'][0]['userDetails']['category']->image)))
														<img src="{{ asset('storage/' . $data['userlist'][0]['userDetails']['category']->image) }}"  class="img-fluid profileImagePreview" style="width: 60px; height: 60px; object-fit: cover; border: 2px solid #e5e7eb; border-radius: 8px;">
													@else
														<img src="{{ asset('front/img/default-placeholder-image.png') }}"  class="img-fluid profileImagePreview" style="width: 60px; height: 60px; object-fit: cover; border: 2px solid #e5e7eb; border-radius: 8px;">
													@endif   
												</div>
												<div>
													<h6 class="text-dark mb-1">{{$data['userlist'][0]['userDetails']['category']->name ?? '-'}}</h6>
													<small class="text-muted">{{ __('Primary Category') }}</small>
												</div>
											</div>
										</div>
										
										<!-- Subcategories -->
										<div class="col-md-6 mb-3">
											<h6 class="text-dark fw-medium mb-3">{{ __('Subcategories') }}</h6>
											@if($data['userlist'][0]->providerDetails && $data['userlist'][0]->providerDetails->count() > 0)
												@foreach($data['userlist'][0]->providerDetails as $providerDetail)
													@if($providerDetail->subcategory)
														<div class="d-flex align-items-center mb-2">
															<span class="badge bg-primary me-2">{{ $providerDetail->subcategory->name }}</span>
														</div>
													@endif
												@endforeach
											@else
												<p class="text-muted mb-0">{{ __('No subcategories assigned') }}</p>
											@endif
										</div>
									</div>
									
									<!-- Services Count -->
									<div class="row mt-3">
										<div class="col-12">
											<div class="border-top pt-3">
												<div class="d-flex justify-content-between align-items-center">
													<h6 class="text-dark fw-medium mb-0">{{ __('Services Offered') }}</h6>
													<span class="badge bg-info">{{ $data['userlist'][0]->products ? $data['userlist'][0]->products->count() : 0 }} {{ __('services') }}</span>
												</div>
												@if($data['userlist'][0]->products && $data['userlist'][0]->products->count() > 0)
													<div class="mt-2">
														@foreach($data['userlist'][0]->products->take(3) as $service)
															<span class="badge bg-light text-dark me-1 mb-1">{{ $service->name }}</span>
														@endforeach
														@if($data['userlist'][0]->products->count() > 3)
															<span class="text-muted">+{{ $data['userlist'][0]->products->count() - 3 }} {{ __('more') }}</span>
														@endif
													</div>
												@else
													<p class="text-muted mb-0 mt-2">{{ __('No services added yet') }}</p>
												@endif
											</div>
										</div>
									</div>
								</div>
							</div>
							@endif
						</div>
						<div class="col-xxl-12 d-flex">
							<div class="card flex-fill">
								<div class="card-header">
									<h5><i class="ti ti-map-pin me-2"></i>{{ __('address')}}</h5>
								</div>
								<div class="card-body">
									<div class="d-flex align-items-center mb-3">
										<span class="avatar avatar-md bg-light-300 rounded me-2 flex-shrink-0 text-default"><i class="ti ti-map-pin-up"></i></span>
										<div>
											<p class="text-dark fw-medium mb-1">{{ __('address')}}</p>
											<p>{{$data['userlist'][0]['userDetails']->address ?? '  -'}} </p>
											<p>{{  App\Models\UserDetail::select('city','state','country')->where('user_id','=',$data['userlist'][0]['userDetails']->user_id)->first()->showfulladdress() }}</p>
											</div>
									</div>
								</div>
							</div>								
						</div>

						@if($data['userlist'][0]->user_type == 2)
						<!-- Provider Statistics & Registration Info -->
						<div class="col-xxl-12 d-flex">
							<div class="card flex-fill">
								<div class="card-header">
									<h5><i class="ti ti-chart-bar me-2"></i>{{ __('Provider Statistics') }}</h5>
								</div>
								<div class="card-body">
									<div class="row">
										<div class="col-md-6 mb-3">
											<div class="d-flex align-items-center">
												<span class="avatar avatar-md bg-primary-100 rounded me-2 flex-shrink-0 text-primary"><i class="ti ti-calendar"></i></span>
												<div>
													<span class="text-dark fw-medium mb-1">{{ __('Registration Date') }}</span>
													<p class="mb-0">{{ \Carbon\Carbon::parse($data['userlist'][0]->created_at)->format($data['DateFormat'] ?? 'd-m-Y') }}</p>
												</div>
											</div>
										</div>
										<div class="col-md-6 mb-3">
											<div class="d-flex align-items-center">
												<span class="avatar avatar-md bg-info-100 rounded me-2 flex-shrink-0 text-info"><i class="ti ti-bookmark"></i></span>
												<div>
													<span class="text-dark fw-medium mb-1">{{ __('Total Bookings') }}</span>
													<p class="mb-0">{{ $data['userlist'][0]->bookings ? $data['userlist'][0]->bookings->count() : 0 }}</p>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>

						<!-- Provider Services -->
						@if($data['userlist'][0]->products && $data['userlist'][0]->products->count() > 0)
						<div class="col-xxl-12 d-flex">
							<div class="card flex-fill">
								<div class="card-header">
									<h5><i class="ti ti-briefcase me-2"></i>{{ __('Services Offered') }}</h5>
								</div>
								<div class="card-body">
									<div class="row">
										@foreach($data['userlist'][0]->products->take(6) as $service)
										<div class="col-md-6 mb-3">
											<div class="border rounded p-3">
												<h6 class="text-dark mb-2">{{ $service->source_name ?? 'Unnamed Service' }}</h6>
												<p class="text-muted mb-2">{!! Str::limit(strip_tags($service->source_description ?? 'No description'), 100) !!}</p>
												<div class="d-flex justify-content-between align-items-center">
													<span class="badge bg-primary">{{ $service->source_price ?? '0' }} USD</span>
													<span class="badge bg-{{ $service->status == 1 ? 'success' : 'danger' }}">
														{{ $service->status == 1 ? __('Active') : __('Inactive') }}
													</span>
												</div>
											</div>
										</div>
										@endforeach
									</div>
									@if($data['userlist'][0]->products && $data['userlist'][0]->products->count() > 6)
									<div class="text-center mt-3">
										<small class="text-muted">{{ __('Showing 6 of') }} {{ $data['userlist'][0]->products->count() }} {{ __('services') }}</small>
									</div>
									@endif
								</div>
							</div>
						</div>
						@endif

						<!-- Provider Subscription Information -->
						<div class="col-xxl-12 d-flex">
							<div class="card flex-fill">
								<div class="card-header">
									<h5><i class="ti ti-crown me-2"></i>{{ __('Subscription Information') }}</h5>
								</div>
								<div class="card-body">
									@if($data['userlist'][0]->activePackageTransaction && $data['userlist'][0]->activePackageTransaction->subscriptionPackage)
										<div class="row">
											<div class="col-md-6 mb-3">
												<h6 class="text-dark fw-medium mb-3">{{ __('Current Package') }}</h6>
												<div class="d-flex align-items-center">
													<span class="avatar avatar-lg bg-primary-100 rounded me-3 flex-shrink-0">
														<i class="ti ti-crown text-primary"></i>
													</span>
													<div>
														<h6 class="text-dark mb-1">{{ $data['userlist'][0]->activePackageTransaction->subscriptionPackage->package_title }}</h6>
														<small class="text-muted">{{ __('Active Subscription') }}</small>
													</div>
												</div>
											</div>
											<div class="col-md-6 mb-3">
												<h6 class="text-dark fw-medium mb-3">{{ __('Package Details') }}</h6>
												<div class="row">
													<div class="col-6">
														<small class="text-muted d-block">{{ __('Price') }}</small>
														<span class="fw-medium">${{ number_format($data['userlist'][0]->activePackageTransaction->subscriptionPackage->price, 2) }}</span>
													</div>
													<div class="col-6">
														<small class="text-muted d-block">{{ __('Duration') }}</small>
														<span class="fw-medium">{{ ucfirst($data['userlist'][0]->activePackageTransaction->subscriptionPackage->package_term) }}</span>
													</div>
												</div>
											</div>
										</div>
										<div class="row mt-3">
											<div class="col-md-6 mb-3">
												<h6 class="text-dark fw-medium mb-3">{{ __('Subscription Status') }}</h6>
												<div class="d-flex align-items-center">
													<span class="badge bg-success me-2">{{ __('Active') }}</span>
													@php
														$endDate = \Carbon\Carbon::parse($data['userlist'][0]->activePackageTransaction->end_date);
														$isLifetime = $endDate->year >= 9999 || $data['userlist'][0]->activePackageTransaction->subscriptionPackage->package_term === 'lifetime';
													@endphp
													@if($isLifetime)
														<small class="text-muted">{{ __('Lifetime Subscription') }} <i class="ti ti-infinity ms-1"></i></small>
													@else
														<small class="text-muted">{{ __('Expires') }}: {{ $endDate->format('M d, Y') }}</small>
													@endif
												</div>
											</div>
											<div class="col-md-6 mb-3">
												<h6 class="text-dark fw-medium mb-3">{{ __('Package Features') }}</h6>
												<div class="row">
													@if($data['userlist'][0]->activePackageTransaction->subscriptionPackage->number_of_service)
														<div class="col-6 mb-1">
															<small class="text-muted">{{ __('Services') }}: {{ $data['userlist'][0]->activePackageTransaction->subscriptionPackage->number_of_service }}</small>
														</div>
													@endif
													@if($data['userlist'][0]->activePackageTransaction->subscriptionPackage->number_of_product)
														<div class="col-6 mb-1">
															<small class="text-muted">{{ __('Products') }}: {{ $data['userlist'][0]->activePackageTransaction->subscriptionPackage->number_of_product }}</small>
														</div>
													@endif
												</div>
											</div>
										</div>
									@else
										<div class="text-center py-4">
											<span class="avatar avatar-lg bg-warning-100 rounded mb-3">
												<i class="ti ti-alert-triangle text-warning"></i>
											</span>
											<h6 class="text-dark mb-2">{{ __('No Active Subscription') }}</h6>
											<p class="text-muted mb-0">{{ __('This provider does not have an active subscription package.') }}</p>
										</div>
									@endif
								</div>
							</div>
						</div>

						<!-- Provider Languages & Additional Info -->
						<div class="col-xxl-12 d-flex">
							<div class="card flex-fill">
								<div class="card-header">
									<h5><i class="ti ti-info-circle me-2"></i>{{ __('Additional Information') }}</h5>
								</div>
								<div class="card-body">
									<div class="row">
										<div class="col-md-6 mb-3">
											<dl class="row mb-0">
												<dt class="col-6 fw-medium text-dark mb-3">{{ __('Language') }}</dt>
												<dd class="col-6 mb-3">{{ $data['userlist'][0]['userDetails']->language ?? '-' }}</dd>
												<dt class="col-6 fw-medium text-dark mb-3">{{ __('Service Type') }}</dt>
												<dd class="col-6 mb-3">{{ ucfirst($data['userlist'][0]->sub_service_type ?? 'individual') }}</dd>
											</dl>
										</div>
										<div class="col-md-6 mb-3">
											<dl class="row mb-0">
												<dt class="col-6 fw-medium text-dark mb-3">{{ __('Last Login') }}</dt>
												<dd class="col-6 mb-3">-</dd>
												<dt class="col-6 fw-medium text-dark mb-3">{{ __('Email Verified') }}</dt>
												<dd class="col-6 mb-3">
													@if($data['userlist'][0]->email_verified_at)
														<span class="badge bg-success">{{ __('Yes') }}</span>
													@else
														<span class="badge bg-danger">{{ __('No') }}</span>
													@endif
												</dd>
											</dl>
										</div>
									</div>
								</div>
							</div>
						</div>
						@endif

						@if ($data['userlist'][0]->user_type == 2 && $data['userlist'][0]->identityVerification)
						<div class="col-xxl-12 d-flex">
							<div class="card flex-fill">
								<div class="card-header">
									<h5>{{ __('Identity Verification') }}</h5>
								</div>
								<div class="card-body">
									@php
										$verification = $data['userlist'][0]->identityVerification;
									@endphp
									
								<!-- Verification Status Badge & Actions -->
								<div class="d-flex justify-content-between align-items-center mb-4">
									<div>
										@if($verification->verification_status === 'pending')
											<span class="badge bg-warning d-inline-flex align-items-center">
												<i class="ti ti-clock fs-5 me-1"></i>{{ __('Pending Review') }}
											</span>
										@elseif($verification->verification_status === 'verified')
											<span class="badge bg-success d-inline-flex align-items-center">
												<i class="ti ti-check fs-5 me-1"></i>{{ __('Verified') }}
											</span>
											@if($verification->verified_at)
												<small class="text-muted ms-2">Verified on {{ $verification->verified_at->format('M d, Y') }}</small>
											@endif
										@else
											<span class="badge bg-danger d-inline-flex align-items-center">
												<i class="ti ti-x fs-5 me-1"></i>{{ __('Rejected') }}
											</span>
										@endif
									</div>
									
									@if($verification->verification_status === 'pending')
									<div>
										<button type="button" class="btn btn-success btn-sm me-2" data-bs-toggle="modal" data-bs-target="#verifyIdModal">
											<i class="ti ti-check me-1"></i>{{ __('Verify') }}
										</button>
										<button type="button" class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectIdModal">
											<i class="ti ti-x me-1"></i>{{ __('Reject') }}
										</button>
									</div>
									@endif
								</div>
								
								<!-- ID Documents in Row Layout -->
								<div class="row">
									<div class="col-md-6 mb-4">
										<h6 class="text-dark fw-medium mb-3">{{ __('ID Document') }}</h6>
										@if($verification->id_document_front)
											@php
												$idPath = 'storage/provider-verification/' . $verification->user_id . '/' . $verification->id_document_front;
												$idUrl = asset($idPath);
											@endphp
											<div class="text-center">
												<a href="{{ $idUrl }}" target="_blank" data-bs-toggle="modal" data-bs-target="#idFrontModal">
													<img src="{{ $idUrl }}" alt="ID Document" class="img-thumbnail d-block mx-auto" style="max-width: 100%; cursor: pointer; border-radius: 8px;" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
													<div style="display:none; color: red; font-size: 11px;">Image not found: {{ $idPath }}</div>
												</a>
												<small class="text-muted d-block mt-1" style="font-size: 10px;">Path: {{ $idPath }}</small>
											</div>
										@else
											<p class="text-muted text-center">{{ __('Not uploaded') }}</p>
										@endif
									</div>
									
									<div class="col-md-6 mb-4">
										<h6 class="text-dark fw-medium mb-3">{{ __('Selfie Photo') }}</h6>
										@if($verification->selfie_photo)
											@php
												$selfiePath = 'storage/provider-verification/' . $verification->user_id . '/' . $verification->selfie_photo;
												$selfieUrl = asset($selfiePath);
											@endphp
											<div class="text-center">
												<a href="{{ $selfieUrl }}" target="_blank" data-bs-toggle="modal" data-bs-target="#selfieModal">
													<img src="{{ $selfieUrl }}" alt="Selfie" class="img-thumbnail d-block mx-auto" style="max-width: 100%; cursor: pointer; border-radius: 8px;" onerror="this.style.display='none'; this.nextElementSibling.style.display='block';">
													<div style="display:none; color: red; font-size: 11px;">Image not found: {{ $selfiePath }}</div>
												</a>
												<small class="text-muted d-block mt-1" style="font-size: 10px;">Path: {{ $selfiePath }}</small>
											</div>
										@else
											<p class="text-muted text-center">{{ __('Not uploaded') }}</p>
										@endif
									</div>
								</div>
									
								@if($verification->rejection_reason)
								<div class="alert alert-danger">
									<strong>{{ __('Rejection Reason:') }}</strong>
									<p class="mb-0">{{ $verification->rejection_reason }}</p>
								</div>
								@endif
								</div>
							</div>								
						</div>
						@endif
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="modal fade" id="verifyProviderModal">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<form method="POST" id="verifyProviderForm">
					@csrf
					<input type="hidden" name="provider_id" id="provider_id" value="{{ $data['userlist'][0]->id }}">
					<div class="modal-body text-center">
						<span class="fs-30 text-success">
							<i class="ti ti-shield-check"></i>
						</span>
						<h4>{{ __('confirm_verification') }}</h4>
						<p>{{ __('confirm_provider_verification_info') }}</p>
						<div class="d-flex justify-content-center">
							<button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
							<button type="button" class="btn btn-success" id="confirmVerifyBtn" data-verifying="{{ __('verifying') }}" data-yes_verify="{{ __('Yes, Verify') }}">{{ __('Yes, Verify') }}</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>

	<!-- ID Document Image Modal -->
	<div class="modal fade" id="idFrontModal" tabindex="-1">
		<div class="modal-dialog modal-lg modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">{{ __('ID Document') }}</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body text-center">
					@if($data['userlist'][0]->user_type == 2 && $data['userlist'][0]->identityVerification && $data['userlist'][0]->identityVerification->id_document_front)
						<img src="{{ asset('storage/provider-verification/' . $data['userlist'][0]->identityVerification->user_id . '/' . $data['userlist'][0]->identityVerification->id_document_front) }}" alt="ID Document" class="img-fluid" style="max-width: 100%;">
					@endif
				</div>
			</div>
		</div>
	</div>

	<!-- Selfie Photo Modal -->
	<div class="modal fade" id="selfieModal" tabindex="-1">
		<div class="modal-dialog modal-lg modal-dialog-centered">
			<div class="modal-content">
				<div class="modal-header">
					<h5 class="modal-title">{{ __('Selfie Photo') }}</h5>
					<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
				</div>
				<div class="modal-body text-center">
					@if($data['userlist'][0]->user_type == 2 && $data['userlist'][0]->identityVerification && $data['userlist'][0]->identityVerification->selfie_photo)
						<img src="{{ asset('storage/provider-verification/' . $data['userlist'][0]->identityVerification->user_id . '/' . $data['userlist'][0]->identityVerification->selfie_photo) }}" alt="Selfie" class="img-fluid" style="max-width: 100%;">
					@endif
				</div>
			</div>
		</div>
	</div>

	<!-- Verify ID Modal -->
	<div class="modal fade" id="verifyIdModal">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<form method="POST" id="verifyIdForm">
					@csrf
					<input type="hidden" name="verification_id" id="verification_id" value="{{ $data['userlist'][0]->identityVerification->id ?? '' }}">
					<input type="hidden" name="user_id" value="{{ $data['userlist'][0]->id }}">
					<div class="modal-body text-center">
						<span class="fs-30 text-success">
							<i class="ti ti-shield-check"></i>
						</span>
						<h4>{{ __('Verify Identity Documents') }}</h4>
						<p>{{ __('Are you sure you want to verify this provider\'s identity documents?') }}</p>
						<div class="d-flex justify-content-center">
							<button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
							<button type="button" class="btn btn-success" id="confirmVerifyIdBtn">
								<i class="ti ti-check me-1"></i>{{ __('Yes, Verify') }}
							</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>

	<!-- Reject ID Modal -->
	<div class="modal fade" id="rejectIdModal">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
				<form method="POST" id="rejectIdForm">
					@csrf
					<input type="hidden" name="verification_id" value="{{ $data['userlist'][0]->identityVerification->id ?? '' }}">
					<input type="hidden" name="user_id" value="{{ $data['userlist'][0]->id }}">
					<div class="modal-header">
						<h5 class="modal-title">{{ __('Reject Identity Documents') }}</h5>
						<button type="button" class="btn-close" data-bs-dismiss="modal"></button>
					</div>
					<div class="modal-body">
						<div class="mb-3">
							<label for="rejection_reason" class="form-label">{{ __('Rejection Reason') }} <span class="text-danger">*</span></label>
							<textarea class="form-control" id="rejection_reason" name="rejection_reason" rows="4" required placeholder="{{ __('Please provide a reason for rejection...') }}"></textarea>
						</div>
						<div class="d-flex justify-content-end">
							<button type="button" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
							<button type="button" class="btn btn-danger" id="confirmRejectIdBtn">
								<i class="ti ti-x me-1"></i>{{ __('Reject') }}
							</button>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>

	<script>
		document.addEventListener('DOMContentLoaded', function() {
			// Verify ID
			const verifyBtn = document.getElementById('confirmVerifyIdBtn');
			let isVerifying = false; // Prevent double-click
			if (verifyBtn) {
				verifyBtn.addEventListener('click', function() {
					if (isVerifying) return; // Prevent duplicate requests
					isVerifying = true;
					
					const verificationId = document.getElementById('verification_id').value;
					const userId = document.querySelector('input[name="user_id"]').value;
					
					fetch('/admin/provider/identity-verification/verify', {
						method: 'POST',
						headers: {
							'Content-Type': 'application/json',
							'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
						},
						body: JSON.stringify({
							verification_id: verificationId,
							user_id: userId
						})
					})
					.then(response => response.json())
					.then(data => {
						const modal = bootstrap.Modal.getInstance(document.getElementById('verifyIdModal'));
						if (modal) modal.hide();
						if (typeof toastr !== 'undefined') {
							toastr.success('Identity verified successfully!');
						}
						setTimeout(() => location.reload(), 1000);
					})
					.catch(error => {
						isVerifying = false; // Reset flag on error
						if (typeof toastr !== 'undefined') {
							toastr.error('Failed to verify identity: ' + error.message);
						} else {
							alert('Failed to verify identity');
						}
					});
				});
			}

			// Reject ID
			const rejectBtn = document.getElementById('confirmRejectIdBtn');
			if (rejectBtn) {
				rejectBtn.addEventListener('click', function() {
					const reason = document.getElementById('rejection_reason').value;
					if (!reason || reason.trim() === '') {
						if (typeof toastr !== 'undefined') {
							toastr.error('Please provide a rejection reason');
						} else {
							alert('Please provide a rejection reason');
						}
						return;
					}

					const verificationId = document.querySelector('#rejectIdForm input[name="verification_id"]').value;
					const userId = document.querySelector('#rejectIdForm input[name="user_id"]').value;
					
					fetch('/admin/provider/identity-verification/reject', {
						method: 'POST',
						headers: {
							'Content-Type': 'application/json',
							'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
						},
						body: JSON.stringify({
							verification_id: verificationId,
							user_id: userId,
							rejection_reason: reason
						})
					})
					.then(response => response.json())
					.then(data => {
						const modal = bootstrap.Modal.getInstance(document.getElementById('rejectIdModal'));
						if (modal) modal.hide();
						if (typeof toastr !== 'undefined') {
							toastr.success('Identity rejected successfully!');
						}
						setTimeout(() => location.reload(), 1000);
					})
					.catch(error => {
						if (typeof toastr !== 'undefined') {
							toastr.error('Failed to reject identity: ' + error.message);
						} else {
							alert('Failed to reject identity');
						}
					});
				});
			}
		});
	</script>

@endsection