@extends('provider.provider')

@section('content')
<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="page-title">{{ __('My Purchased Profiles') }}</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('provider.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('provider.paradigm.marketplace') }}">{{ __('Marketplace') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('My Purchases') }}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover table-center mb-0">
                                <thead>
                                    <tr>
                                        <th>{{ __('Client Name') }}</th>
                                        <th>{{ __('Paradigm Type') }}</th>
                                        <th>{{ __('Purchase Price') }}</th>
                                        <th>{{ __('Purchase Date') }}</th>
                                        <th>{{ __('Link Status') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($purchases as $purchase)
                                        @php
                                            $result = $purchase->result;
                                            $linkRequest = $purchase->linkRequest;
                                        @endphp
                                        @if($result)
                                        <tr>
                                            <td>{{ $result->name ?? 'N/A' }} {{ $result->surname ?? '' }}</td>
                                            <td>
                                                <span class="badge bg-info">{{ $result->paradigm_type ?? 'N/A' }}</span>
                                            </td>
                                            <td>{{ number_format($purchase->purchase_price, 2) }} {{ __('Credits') }}</td>
                                            <td>{{ $purchase->purchased_at->format('Y-m-d H:i') }}</td>
                                            <td>
                                                @if($linkRequest)
                                                    @if($linkRequest->status == 'accepted')
                                                        <span class="badge bg-success">{{ __('Linked') }}</span>
                                                    @elseif($linkRequest->status == 'declined')
                                                        <span class="badge bg-danger">{{ __('Declined') }}</span>
                                                    @else
                                                        <span class="badge bg-warning">{{ __('Pending') }}</span>
                                                    @endif
                                                @else
                                                    <span class="badge bg-secondary">{{ __('No Request') }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                <a href="{{ route('provider.paradigm.marketplace.download', $result->id) }}" class="btn btn-sm btn-primary me-1" target="_blank">
                                                    <i class="ti ti-download me-1"></i>{{ __('Download') }}
                                                </a>
                                                <a href="{{ route('provider.paradigm.marketplace.transfer', $purchase->id) }}" class="btn btn-sm btn-info">
                                                    <i class="ti ti-transfer me-1"></i>{{ __('Transfer') }}
                                                </a>
                                            </td>
                                        </tr>
                                        @endif
                                    @empty
                                        <tr>
                                            <td colspan="6" class="text-center">{{ __('No purchased profiles found') }}</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <div class="mt-3">
                            {{ $purchases->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

