@extends('provider.provider')

@section('content')
<div class="page-wrapper">
    <div class="content container-fluid">
        <div class="page-header">
            <div class="row align-items-center">
                <div class="col">
                    <h3 class="page-title">{{ __('Profile Details') }}</h3>
                    <ul class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('provider.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('provider.paradigm.marketplace') }}">{{ __('Marketplace') }}</a></li>
                        <li class="breadcrumb-item active">{{ __('Profile Details') }}</li>
                    </ul>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-8 offset-md-2">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title mb-0">{{ __('Profile Information') }}</h5>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>{{ __('Client Name') }}:</strong>
                                <p>{{ $result->name }} {{ $result->surname }}</p>
                            </div>
                            <div class="col-md-6">
                                <strong>{{ __('Paradigm Type') }}:</strong>
                                <p><span class="badge bg-info">{{ $result->paradigm_type ?? 'N/A' }}</span></p>
                            </div>
                        </div>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <strong>{{ __('Price') }}:</strong>
                                <p class="h4 text-primary">{{ number_format($price, 2) }} {{ __('Credits') }}</p>
                            </div>
                            <div class="col-md-6">
                                <strong>{{ __('Your Wallet Balance') }}:</strong>
                                <p class="h5">{{ number_format($balance, 2) }} {{ __('Credits') }}</p>
                            </div>
                        </div>

                        @if($balance < $price)
                            <div class="alert alert-warning">
                                <i class="ti ti-alert-triangle me-2"></i>
                                {{ __('Insufficient wallet balance. Please top up your wallet.') }}
                                <a href="{{ route('provider.wallet.topup') }}" class="btn btn-sm btn-primary ms-2">
                                    {{ __('Top Up Wallet') }}
                                </a>
                            </div>
                        @endif

                        <div class="d-flex justify-content-between mt-4">
                            <a href="{{ route('provider.paradigm.marketplace') }}" class="btn btn-secondary">
                                <i class="ti ti-arrow-left me-1"></i>{{ __('Back') }}
                            </a>
                            <button type="button" class="btn btn-primary" id="purchaseBtn" {{ $balance < $price ? 'disabled' : '' }}>
                                <i class="ti ti-shopping-cart me-1"></i>{{ __('Purchase Profile') }}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    $('#purchaseBtn').on('click', function() {
        if ($(this).prop('disabled')) return;
        
        if (!confirm('{{ __("Are you sure you want to purchase this profile for :price credits?") }}'.replace(':price', '{{ number_format($price, 2) }}'))) {
            return;
        }

        $.ajax({
            url: '{{ route("provider.paradigm.marketplace.purchase", $result->id) }}',
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success(response.message);
                    if (response.redirect) {
                        window.location.href = response.redirect;
                    }
                } else {
                    toastr.error(response.message);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                if (response && response.message) {
                    toastr.error(response.message);
                } else {
                    toastr.error('{{ __("Purchase failed") }}');
                }
            }
        });
    });
});
</script>
@endpush

