@extends('provider.provider')

@section('content')

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="content container-fluid">
        <!-- Profile settings -->
        <div class="row">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
                        <h5>{{__('profile_settings')}}</h5>
                    </div>
                </div>
            </div>
            <div class="col-lg-10 mx-auto">
                <!-- Account Settings -->
                <div class="card mb-0">
                    <div class="card-body">
                        <form id="providerProfileForm">
                            <input type="hidden" name="id" id="id" value="{{ $data->id ?? ''}}">
                            
                            @if(Auth::user()->user_type == 4 && Auth::user()->is_company_owner)
                            {{-- COMPANY OWNER: Show info banner --}}
                            <div class="alert alert-info d-flex align-items-center mb-4" role="alert">
                                <i class="ti ti-building me-2 fs-20"></i>
                                <div>
                                    <strong>{{__('Company Owner Account')}}</strong><br>
                                    <small>{{__('Company details are managed in the Branch section. Your main branch information will be displayed on Paradigm Profiles.')}}</small>
                                </div>
                            </div>
                            @endif
                            
                            <h6 class="user-title">{{__('profile_picture')}}</h6>
                            <div class="">
                                <div class="pro-picture d-flex flex-wrap gap-2">
                                    <div class="pro-img avatar avatar-xl flex-shrink-0">
                                        <img src="{{ $data->userDetails->profile_image ? (str_contains($data->userDetails->profile_image, 'http') ? $data->userDetails->profile_image : asset('storage/profile/' . $data->userDetails->profile_image)) : asset('assets/img/profile-default.png') }}"
                                            alt="user" class="img-fluid profileImagePreview" style="border-radius: 8px; width: 80px; height: 80px; object-fit: cover;">
                                    </div>
                                    <div class="pro-info">
                                        <div class="d-flex mb-2">
                                            <input type="file" class="" name="profile_image" id="profile_image">
                                        </div>
                                        <p class="fs-14">{{(__('image_size_note'))}}</p>
                                        <span class="text-danger error-text" id="profile_image_error"></span>
                                    </div>
                                </div>
                            </div>
                            <h6 class="user-title">{{__('general_information')}}</h6>
                            <div class="general-info">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{__('first_name')}}<span class="text-danger">
                                                    *</span></label>
                                            <input type="text" class="form-control" name="first_name" id="first_name"
                                                value="{{ $data->userDetails->first_name ?? ''}}">
                                            <span class="text-danger error-text" id="first_name_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{__('last_name')}}<span class="text-danger">
                                                    *</span></label>
                                            <input type="text" class="form-control" id="last_name" name="last_name"
                                                value="{{ $data->userDetails->last_name ?? ''}}">
                                            <span class="text-danger error-text" id="last_name_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="mb-3">
                                            <label class="form-label">{{__('email')}}<span class="text-danger">
                                                    *</span></label>
                                            <input type="text" class="form-control" name="email" id="email"
                                                value="{{ $data->email ?? ''}}">
                                            <span class="text-danger error-text" id="email_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{__('user_name')}}<span class="text-danger">
                                                    *</span></label>
                                            <input type="text" class="form-control" name="user_name" id="user_name"
                                                value="{{ $data->name ?? ''}}">
                                            <span class="text-danger error-text" id="user_name_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{__('phone_number')}}<span class="text-danger">
                                                    *</span></label>
                                            <input type="text" class="form-control provider_phone_number"
                                                name="phone_number" id="phone_number"
                                                value="{{ $data->phone_number ?? ''}}">
                                            <input type="hidden" id="provider_phone_number"
                                                name="international_phone_number">
                                            <span class="text-danger error-text" id="phone_number_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{__('gender')}}<span class="text-danger">
                                                    *</span></label>
                                            <select class="select form-control select2" id="gender" name="gender">
                                                <option value="">{{__('select_gender')}}</option>
                                                <option value="male" {{ ($data->userDetails->gender ?? '') == 'male' ? 'selected' : '' }}>{{__('male')}}</option>
                                                <option value="female" {{ ($data->userDetails->gender ?? '') == 'female' ? 'selected' : '' }}>{{__('female')}}</option>
                                            </select>
                                            <span class="text-danger error-text" id="gender_error"></span>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">{{__('date_of_birth')}}<span class="text-danger">
                                                    *</span></label>
                                            <div class=" input-icon position-relative">
                                                <input type="date" class="form-control" name="dob" id="dob"
                                                    placeholder="dd-mm-yyyy"
                                                    max="{{ date('Y-m-d', strtotime('-1 day')) }}"
                                                    value="{{ $data->userDetails->dob ?? ''}}">
                                                <span class="text-danger error-text" id="dob_error"></span>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div>
                                            <label class="form-label">{{__('your_bio')}}</label>
                                            <textarea class="form-control" rows="4" name="bio"
                                                id="bio">{{ $data->userDetails->bio ?? ''}}</textarea>
                                            <span class="text-danger error-text" id="bio_error"></span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <h6 class="user-title">{{__('address_information')}}</h6>
                            <div class="row address-info mb-2">
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('address')}}<span class="text-danger">
                                                *</span></label>
                                        <input type="text" class="form-control" id="address" name="address"
                                            value="{{ $data->userDetails->address ?? ''}}">
                                        <span class="text-danger error-text" id="address_error"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('country')}}<span class="text-danger">
                                                *</span></label>
                                        <select class="select form-control select2" id="country" name="country"
                                            data-placeholder="{{__('select_country')}}"
                                            data-country="{{ $data->userDetails->country ?? ''}}">
                                        </select>
                                        <span class="text-danger error-text" id="country_error"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('state')}}<span class="text-danger">
                                                *</span></label>
                                        <select class="select form-control select2" id="state" name="state"
                                            data-placeholder="{{__('select_state')}}"
                                            data-state="{{ $data->userDetails->state ?? ''}}">
                                        </select>
                                        <span class="text-danger error-text" id="state_error"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('city')}}<span class="text-danger">
                                                *</span></label>
                                        <select class="select form-control select2" id="city" name="city"
                                            data-placeholder="{{__('select_city')}}"
                                            data-city="{{ $data->userDetails->city ?? ''}}">
                                        </select>
                                        <span class="text-danger error-text" id="city_error"></span>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('postal_code')}}<span class="text-danger">
                                                *</span></label>
                                        <input type="text" class="form-control" id="postal_code" name="postal_code"
                                            value="{{ $data->userDetails->postal_code ?? ''}}">
                                        <span class="text-danger error-text" id="postal_code_error"></span>
                                    </div>
                                </div>
                                <div class="col-md-6 d-none">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('currency_code')}}<span class="text-danger">
                                                *</span></label>
                                        <select class="select form-control select2" id="currency_code"
                                            name="currency_code" data-placeholder="Select Currency Code">
                                            @if ($currencyDetails)
                                                @foreach ($currencyDetails as $currency)
                                                    <option value="{{ $currency->code }}" {{ ($data->userDetails->currency_code ?? '') == $currency->code ? 'selected' : '' }}>{{ $currency->code }}
                                                    </option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <span class="text-danger error-text" id="currency_code_error"></span>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">{{__('language')}}</label>
                                        <input class="input-tags form-control" type="text" data-role="tagsinput"
                                            name="language" id="language"
                                            value="{{ $data->userDetails->language ?? ''}}">
                                    </div>
                                </div>
                            </div>
                            <div class="acc-submit d-flex justify-content-end">
                                <button type="submit" class="btn btn-dark" id="save_provider" data-save="{{ __('save_changes') }}">{{__('save_changes')}}</button>
                            </div>
                        </form>
                    </div>
                </div>

            </div>
            <!-- /Account Settings -->

        </div>
        <!-- /profile-settings -->

    </div>
</div>
<!-- /Page Wrapper -->

@endsection

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Wait for jQuery to be available
    function waitForJQuery(callback) {
        if (typeof jQuery !== 'undefined') {
            callback(jQuery);
        } else {
            setTimeout(function() {
                waitForJQuery(callback);
            }, 100);
        }
    }

    waitForJQuery(function($) {
        // Profile image preview
        $('#profile_image').on('change', function(event) {
            if ($(this).val() !== "") {
                $(this).valid();
            }
            let reader = new FileReader();
            reader.onload = function (e) {
                $('.profileImagePreview').attr('src', e.target.result).show();
            };
            reader.readAsDataURL(event.target.files[0]);
        });

        // Company image preview
        $('#company_image').on('change', function(event) {
            if ($(this).val() !== "") {
                $(this).valid();
            }
            let reader = new FileReader();
            reader.onload = function (e) {
                $('#companyImagePreview').attr('src', e.target.result).show();
            };
            reader.readAsDataURL(event.target.files[0]);
        });

        // Form submission
        $('#providerProfileForm').on('submit', function(e) {
            e.preventDefault();
            
            var formData = new FormData(this);
            
            $.ajax({
                url: '/api/provider/update-profile',
                type: 'POST',
                data: formData,
                processData: false,
                contentType: false,
                headers: {
                    'Authorization': 'Bearer ' + localStorage.getItem('provider_token'),
                    'Accept': 'application/json'
                },
                success: function(response) {
                    if (response.code === 200) {
                        if (typeof toastr !== 'undefined') {
                            toastr.success(response.message);
                        } else {
                            alert('Profile updated successfully!');
                        }
                        // Update the profile image in the header if it exists
                        if (response.data && response.data.profile_image) {
                            // Ensure we only use the filename, not the full URL
                            let imagePath = response.data.profile_image;
                            if (imagePath.includes('storage/profile/')) {
                                imagePath = imagePath.split('storage/profile/')[1];
                            }
                            if (imagePath.includes('https://') || imagePath.includes('http://')) {
                                imagePath = imagePath.split('/').pop();
                            }
                            $('.headerProfileImg').attr('src', '/storage/profile/' + imagePath);
                        }
                    } else {
                        if (typeof toastr !== 'undefined') {
                            toastr.error(response.message);
                        } else {
                            alert('Error: ' + response.message);
                        }
                    }
                },
                error: function(xhr) {
                    if (xhr.responseJSON && xhr.responseJSON.errors) {
                        $.each(xhr.responseJSON.errors, function(key, value) {
                            $('#' + key + '_error').text(value[0]);
                        });
                    } else if (xhr.responseJSON && xhr.responseJSON.message) {
                        if (typeof toastr !== 'undefined') {
                            toastr.error(xhr.responseJSON.message);
                        } else {
                            alert('Error: ' + xhr.responseJSON.message);
                        }
                    } else {
                        if (typeof toastr !== 'undefined') {
                            toastr.error('An error occurred while updating profile.');
                        } else {
                            alert('An error occurred while updating profile.');
                        }
                    }
                }
            });
        });
    });
});
</script>