@extends('layouts.clean')

@section('title', $template->name)
@section('description', $template->description)

@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css">
<style>
    /* ... existing styles ... */
</style>
@endpush

@section('content')
<div class="assessment-container">
    <form id="paradigmAssessmentForm" action="{{ route('paradigm.assessment.submit') }}" method="POST" novalidate>
        @csrf
        <input type="hidden" name="template_id" value="{{ $template->id }}">

        <!-- Stepper Navigation -->
        <div class="stepper-wrapper">
            @if ($template->personalFields->count() > 0)
                <div class="step-item active" data-step="1">
                    <div class="step-number">1</div>
                    <div class="step-label">Personal Details</div>
                </div>
            @endif

            @php $partNumber = ($template->personalFields->count() > 0) ? 2 : 1; @endphp

            @if ($template->questions->where('question_type', 'part1')->count() > 0)
                <div class="step-item @if($partNumber == 1) active @endif" data-step="{{ $partNumber }}">
                    <div class="step-number">{{ $partNumber }}</div>
                    <div class="step-label">Part 1</div>
                </div>
                @php $partNumber++; @endphp
            @endif

            @if ($template->questions->where('question_type', 'part2')->count() > 0)
                <div class="step-item" data-step="{{ $partNumber }}">
                    <div class="step-number">{{ $partNumber }}</div>
                    <div class="step-label">Part 2</div>
                </div>
            @endif
        </div>

        @php $partNumber = 1; @endphp

        @if ($template->personalFields->count() > 0)
            <div class="step-content active" data-step="{{ $partNumber }}">
                <h2>Personal Details</h2>
                <p>Please provide your information below.</p>
                <div class="personal-fields-grid">
                    @foreach ($personal_fields as $field)
                        <div class="form-group">
                            <label for="personal_{{ $field->field_key }}">{{ $field->field_name }}: @if($field->is_required)<span class="required">*</span>@endif</label>
                            @if ($field->field_type === 'select')
                                <select class="form-control" id="personal_{{ $field->field_key }}" name="personal[{{ $field->field_key }}]" @if($field->is_required) required @endif>
                                    <option value="">Select an option</option>
                                    @foreach ($field->getOptionsArray() as $option)
                                        <option value="{{ $option }}">{{ $option }}</option>
                                    @endforeach
                                </select>
                            @else
                                <input type="{{ $field->field_type }}" class="form-control" id="personal_{{ $field->field_key }}" name="personal[{{ $field->field_key }}]" @if($field->is_required) required @endif>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
            @php $partNumber++; @endphp
        @endif

        @if ($template->questions->where('question_type', 'part1')->count() > 0)
            <div class="step-content @if($partNumber == 1) active @endif" data-step="{{ $partNumber }}">
                <h2>Part 1</h2>
                <p>For each question, choose your top 3 options by clicking in order of preference: 1st click – Most likely, 2nd click – Second most likely, 3rd click – Third most likely.</p>
                @foreach($template->questions->where('question_type', 'part1') as $question)
                <div class="question-block" id="question_{{ $question->id }}" data-question-type="ranking">
                    <p class="question-text">{{ $loop->iteration }}. {{ $question->question_text }}</p>
                    <div class="options-wrapper">
                        @foreach(['A', 'B', 'C', 'D'] as $optionKey)
                            <div class="option" data-question-id="{{ $question->id }}" data-option="{{ $optionKey }}">
                                <span class="option-letter">{{ $optionKey }}</span>
                                <span class="option-text">{{ $question->{'option_' . strtolower($optionKey) . '_text'} }}</span>
                                <div class="ranking-badge"></div>
                            </div>
                        @endforeach
                    </div>
                    <input type="hidden" name="questions[{{ $question->id }}][A]" id="q_{{ $question->id }}_A_input" value="0">
                    <input type="hidden" name="questions[{{ $question->id }}][B]" id="q_{{ $question->id }}_B_input" value="0">
                    <input type="hidden" name="questions[{{ $question->id }}][C]" id="q_{{ $question->id }}_C_input" value="0">
                    <input type="hidden" name="questions[{{ $question->id }}][D]" id="q_{{ $question->id }}_D_input" value="0">
                </div>
                @endforeach
            </div>
            @php $partNumber++; @endphp
        @endif

        @if ($template->questions->where('question_type', 'part2')->count() > 0)
            <div class="step-content" data-step="{{ $partNumber }}">
                <h2>Part 2</h2>
                <p>For each question, select the option that is most like you.</p>
                @foreach($template->questions->where('question_type', 'part2') as $question)
                <div class="question-block" id="question_{{ $question->id }}" data-question-type="choice">
                    <p class="question-text">{{ $question->question_text }}</p>
                    <div class="options-wrapper-choice">
                        <label class="option-choice">
                            <input type="radio" name="questions[{{ $question->id }}]" value="A">
                            <span class="option-text">{{ $question->option_a_text }}</span>
                        </label>
                        <label class="option-choice">
                            <input type="radio" name="questions[{{ $question->id }}]" value="B">
                            <span class="option-text">{{ $question->option_b_text }}</span>
                        </label>
                    </div>
                </div>
                @endforeach
            </div>
        @endif

        <div class="navigation-buttons">
            <button type="button" class="btn btn-secondary" id="prevBtn" style="display: none;">Previous</button>
            <button type="button" class="btn btn-primary" id="nextBtn">Next</button>
            <button type="submit" class="btn btn-success" id="submitBtn" style="display: none;">Submit</button>
        </div>
    </form>
</div>
@endsection

@push('scripts')
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script>
    // ... all the javascript for stepper, ranking, save/load progress...

        const form = document.getElementById('paradigmAssessmentForm');
        form.addEventListener('submit', function (event) {
            event.preventDefault();
            
            // Re-enable all inputs for submission
            const allInputs = form.querySelectorAll('input, select');
            allInputs.forEach(input => input.disabled = false);

            const formData = new FormData(form);
            const personalData = {};
            const questionData = {};

            const rankingSelections = {};

            for (let [key, value] of formData.entries()) {
                const personalMatch = key.match(/^personal\[(.*?)\]$/);
                if (personalMatch) {
                    personalData[personalMatch[1]] = value;
                    continue;
                }
                
                const questionMatch = key.match(/^questions\[(\d+)\](?:\[([A-D])\])?$/);
                if (questionMatch) {
                    const questionId = questionMatch[1];
                    const option = questionMatch[2];

                    if (option) { // Ranking question
                        if (!rankingSelections[questionId]) {
                            rankingSelections[questionId] = {};
                        }
                        const rank = parseInt(value, 10);
                        if (rank > 0) { // Only include ranked items
                           rankingSelections[questionId][option] = rank;
                        }
                    } else { // Choice question
                        questionData[questionId] = value;
                    }
                }
            }

            // Add the processed ranking data to the main question data object
            Object.assign(questionData, rankingSelections);

            console.log('Submitting Data:', { personalData, questionData });

            fetch(form.action, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                    'Accept': 'application/pdf', 
                },
                body: JSON.stringify({
                    template_id: form.querySelector('input[name="template_id"]').value,
                    personal: personalData,
                    questions: questionData,
                }),
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Handle file download via direct navigation
                    if (data.download_url) {
                        const link = document.createElement('a');
                        link.href = data.download_url;
                        link.download = ''; 
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                    }
                    
                    alert('Assessment completed successfully! Your report is downloading.');
                    
                    // Redirect to completion page
                    if (data.redirect_url) {
                        setTimeout(function() {
                            window.location.href = data.redirect_url;
                        }, 2000);
                    }
                    
                    // Clear progress
                    localStorage.removeItem(`paradigm_progress_{{ $template->id }}`);
                } else {
                    throw new Error(data.message || 'An unknown error occurred.');
                }
            })
            .catch(error => {
                console.error('Submission Error:', error);
                alert('An error occurred during submission: ' + error.message);
            });
        });
    });
</script>
@endpush
