@extends('provider.provider')
@section('content')
 <div class="page-wrapper">
        <div class="content container-fluid">
            <div class="row">
                <div class="d-flex align-items-center justify-content-between flex-wrap row-gap-3 mb-4">
                    <h4>{{ __('Booking List') }}</h4>
                </div>
            </div>
            <div class="row justify-content-center">
                <div class="col-xxl-12 col-lg-12">
					@if(count($data['bookingdata'])>0)
					    @foreach($data['bookingdata'] as $val)
							<div class="card shadow-none booking-list">
									<div class="card-body d-md-flex align-items-start">
										<div class="booking-widget d-sm-flex align-items-center row-gap-3 flex-fill  mb-3 mb-md-0">
											<div class="booking-img me-sm-3 mb-3 mb-sm-0">
												<a href="#" class="avatar">
                                                    <img src="{{ $val->productimage }}" alt="Product Image" class="img-fluid profileImagePreview">
												</a>
											</div>
											<div class="booking-det-info">
												<h6 class="mb-3">
													<a href="#">{{$val->source_name}}  </a><span class="booking-status bookingstatus{{$val->id}}" data-status="{{$val->booking_status}}">{{$val->booking_status_label}}</span>
												</h6>
												<ul class="booking-details">
                                                    <li class="d-flex align-items-center mb-2">
                                                        <span class="book-item">{{__('order_id')}}</span> <small class="me-2">:</small> {{ $val->order_id ?? '-' }}
                                                    </li>
													<li class="d-flex align-items-center mb-2">
														<span class="book-item">{{ __('Booking Date') }}</span> <small class="me-2">: </small>{{$val->bookingdate}}
													</li>
													<li class="d-flex align-items-center mb-2">
														<span class="book-item">{{ __('Amount') }}</span> <small class="me-2">: </small> {{$data['currency']}}{{$val->total_amount}}<span class="badge badge-soft-primary ms-2">{{ $val->paymenttype }}</span>
													</li>
													<li class="d-flex align-items-center mb-2">
														<span class="book-item">{{ __('Location') }}</span> <small class="me-2">: </small>{{$val->user_city}}
													</li>
													<li class="d-flex align-items-center flex-wrap">
														<span class="book-item">{{ __('User') }}</span> <small class="me-2">: </small>
														<div class="user-book d-flex align-items-center flex-wrap me-2">
															<div class="avatar avatar-xs me-2">
                                                                @if (isset( $val->profile_image) && file_exists(public_path('storage/profile/' . $val->profile_image)))
                                                                    <img src="{{ asset('storage/profile/' . $val->profile_image) }}" alt="User Profile Image" class="img-fluid rounded-circle profileImagePreview">
                                                                @else
                                                                    <img src="{{ asset('front/img/profiles/avatar-01.jpg') }}" alt="Default Profile Image" class="img-fluid rounded-circle profileImagePreview">
                                                                @endif
															</div>
															<span class="me-4"> {{$val->user_name ?? ""}} </span>
														</div>
                                                        @if($val->booking_status_label=='Open')
                                                            @if($val->email!='')
                                                                <p class="mb-0 me-2"><i class="ti ti-email fs-10 text-muted me-1"></i>{{($val->email ?? null) ? maskEmail($val->email) : ''}}</p>
                                                            @endif
                                                            @if($val->contact!='')
                                                            <p><i class="ti ti-phone-filled fs-10 text-muted me-2"></i>{{ ($val->contact ?? null) ? mask_mobile_number($val->contact) : '' }}
                                                            </p>
                                                            @endif
                                                        @else
                                                        @if($val->email!='')
                                                        <p class="mb-0 me-2"><i class="ti ti-email fs-10 text-muted me-1"></i>{{$val->email ?? ''}}</p>
                                                        @endif
                                                            @if($val->contact!='')
                                                            <p><i class="ti ti-phone-filled fs-10 text-muted me-2"></i>{{ $val->contact ?? '' }}</p>
                                                            @endif
                                                        @endif
													</li>
												</ul>
											</div>
										</div>
						                    @if($val->booking_status_label=='Open')
                                                <div class="acceptdiv{{$val->id}}  d-flex justify-content-start gap-2">
                                                    <a href="#" class="btn btn-success accept" data-bs-toggle="modal" data-bs-target="#accept" data-id="{{$val->id}}">{{ __('Accept') }}</a>
                                                    <a href="#" class="btn btn-danger cancel" data-bs-toggle="modal" data-bs-target="#cancel_appointment" data-id="{{$val->id}}">{{ __('Cancel') }}</a>
                                                </div>
                                            @elseif($val->booking_status_label=='In progress')
                                                <div class="completediv{{$val->id}}  d-flex justify-content-start gap-2">
                                                    <a href="#" class="btn btn-success complete" data-bs-toggle="modal" data-bs-target="#completed" data-id="{{$val->id}}">{{ __('Complete') }}</a>
                                                    <a href="#" class="btn btn-dark me-2 chattab" data-userid="{{$val->user_id}}" data-user="{{$val->user_name}}" data-authuserid="{{$data['authuserid']}}"><i class="ti ti-message-2 me-2"></i>{{ __('Chat') }}</a>
                                                </div>
                                            @endif
									</div>
								</div>
						@endforeach
					@else
                    <div class="card shadow-none booking-list h-80">
							<div class="card-body d-flex align-items-center justify-content-center">
								<p class="fw-bold">{{ __('No Bookings Available') }}</p>
							</div>
						</div>
					@endif
                </div>
            </div>

            <div class="d-flex justify-content-center">
                {{ $data['bookingdata']->links('pagination::bootstrap-4') }}
            </div>
        </div>
     </div>

    <div class="modal fade" id="accept">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
                <form>
                    <div class="modal-body text-center">
                        <h4>{{ __('Confirm Accept') }}</h4>
                        <p>{{ __('Do You want to accept this booking?') }}</p>
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</a>
                            <button  class="btn btn-success bookingid" id="acceptbooking" data-id="" data-type="2">{{ __('Yes, Confirm') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
	</div>

    <div class="modal fade" id="completed">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
                <form>
                    <div class="modal-body text-center">
                        <h4>{{ __('Confirm Complete') }}</h4>
                        <p>{{ __('Do You want to complete this booking?') }}</p>
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Cancel') }}</a>
                            <button  class="btn btn-success bookingid" id="completebooking" data-id="" data-type="5">{{ __('Yes, Confirm') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
	</div>

    <div class="modal fade custom-modal" id="add_booking">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header d-flex align-items-center justify-content-between border-bottom">
                    <h5 class="modal-title">Add Booking</h5>
                    <a href="javascript:void(0);" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-circle-x-filled fs-20"></i></a>
                </div>
                <form action="provider-booking.html">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">Staff</label>
                                    <select class="select">
                                        <option>Select</option>
                                        <option>Jeff Fitch</option>
                                        <option>Donald Gordon</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">Service</label>
                                    <select class="select">
                                        <option>Select</option>
                                        <option>Computer Services</option>
                                        <option>Car Repair Services</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <label class="form-label">Customer</label>
                                    <select class="select">
                                        <option>Select</option>
                                        <option>Jeff Fitch</option>
                                        <option>Donald Gordon</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-3">
                                    <div class="sel-cal Calendar-icon">
                                        <span><i class="ti ti-calendar-month"></i></span>
                                        <input class="form-control datetimepicker" type="text" placeholder="dd-mm-yyyy">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <div class="sel-cal Calendar-icon">
                                                <span><i class="ti ti-clock"></i></span>
                                                <input class="form-control timepicker" type="text" placeholder="dd-mm-yyyy">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <div class="sel-cal Calendar-icon">
                                                <span><i class="ti ti-clock"></i></span>
                                                <input class="form-control timepicker" type="text" placeholder="dd-mm-yyyy">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-0">
                                    <label class="form-label">Booking Message</label>
                                    <textarea rows="4" class="form-control"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <a href="javascript:void(0);" class="btn btn-light me-2" data-bs-dismiss="modal">Cancel</a>
                        <button type="submit" class="btn btn-dark">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

	<div class="modal fade custom-modal" id="reschedule">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header d-flex align-items-center justify-content-between border-bottom">
                    <h5 class="modal-title">Reschedule Appointment</h5>
                    <a href="javascript:void(0);" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-circle-x-filled fs-20"></i></a>
                </div>
                <div class="modal-body">
                    <form action="user-bookings.html">
                        <div class="mb-3">
							<label class="form-label">Appointment Date</label>
							<div class="form-icon">
								<input type="text" class="form-control datetimepicker" placeholder="DD/MM/YYYY">
								<span class="cus-icon"><i class="feather-calendar"></i></span>
							</div>
						</div>
						<div class="mb-0">
							<label class="form-label">Appointment Time</label>
							<div class="form-icon">
								<input type="text" class="form-control timepicker" placeholder="DD/MM/YYYY">
								<span class="cus-icon"><i class="feather-clock"></i></span>
							</div>
						</div>
                    </form>
                </div>
                <div class="modal-footer">
                    <div class="acc-submit">
                        <a href="javascript:void(0);" class="btn btn-light me-2" data-bs-dismiss="modal">Cancel</a>
                        <button class="btn btn-dark" type="submit">Save</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

	<div class="modal fade custom-modal" id="cancel_appointment">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header d-flex align-items-center justify-content-between border-bottom">
                    <h5 class="modal-title">{{ __('Cancel Booking') }}</h5>
                    <a href="javascript:void(0);" data-bs-dismiss="modal" aria-label="Close"><i class="ti ti-circle-x-filled fs-20"></i></a>
                </div>
				<form>
					<div class="modal-body">
						<p>{{ __('Are you sure you want to cancel this booking?') }}</p>
					</div>
					<div class="modal-footer">
						<div class="acc-submit">
							<a href="javascript:void(0);" class="btn btn-light me-2" data-bs-dismiss="modal">{{ __('Dismiss') }}</a>
							<button class="btn btn-dark bookingid" id="cancelbooking" data-id="" data-type="3" type="submit">{{ __('Yes, Cancel') }}</button>
						</div>
					</div>
				</form>
            </div>
        </div>
    </div>

@endsection
