@extends('front')

@section('content')

<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{__('Dashboard')}}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}"><i class="ti ti-home-2"></i></a></li>
                        <li class="breadcrumb-item">{{__('Customer')}}</li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Dashboard')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
        <div class="breadcrumb-bg">
            <img src="{{ asset('front/img/bg/breadcrumb-bg-01.png') }}" class="breadcrumb-bg-1" alt="Img">
            <img src="{{ asset('front/img/bg/breadcrumb-bg-02.png') }}" class="breadcrumb-bg-2" alt="Img">
        </div>
    </div>
</div>

<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    <!-- Coming Soon Message -->
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <div class="card text-center">
                                <div class="card-body py-5">
                                    <div class="mb-4">
                                        <i class="ti ti-clock-hour-3" style="font-size: 80px; color: #044f54;"></i>
                                    </div>
                                    <h1 class="mb-3" style="color: #044f54; font-weight: 600;">Coming Soon</h1>
                                    <p class="text-muted mb-4" style="font-size: 1.25rem; font-weight: 400;">Our new dashboard is under construction.</p>
                                    <div class="d-flex justify-content-center gap-3 mt-4">
                                        @if(false)
                                        {{-- HIDDEN: My Credits Button --}}
                                        <a href="{{ route('user.wallet') }}" class="btn wallet-btn" style="background-color: #044f54; color: white;">
                                            <i class="ti ti-wallet me-2"></i>My Credits
                                        </a>
                                        @endif
                                        <a href="{{ route('user.paradigm.assessments') }}" class="btn paradigm-btn" style="background-color: #044f54; color: white;">
                                            <i class="ti ti-brain me-2"></i>Paradigm Profiles™
                                        </a>
                                    </div>
                                    <style>
                                    .wallet-btn:hover, .paradigm-btn:hover {
                                        background-color: #033d41 !important;
                                        color: white !important;
                                        opacity: 0.9;
                                    }
                                    </style>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    @if(false)
                    <!-- Hidden Original Dashboard Content -->
                    <div class="skeleton label-skeleton label-loader"></div>
                    <h4 class="mb-3 d-none real-label">{{__('Dashboard')}}</h4>
                    <div class="row mb-1">
                        <div class="col-md-6">
                            <div class="card dash-widget">
                                <div class="card-body">
                                    <div class="d-flex  justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                            <span class="dash-icon bg-primary-transparent d-flex justify-content-center align-items-center rounded-circle">
                                                <i class="ti ti-shopping-cart"></i>
                                            </span>
                                            <div class="ms-2">
                                                <div class="skeleton label-skeleton label-loader"></div>
                                                <span class="fs-14 d-none real-label">{{__('Total Orders')}}</span>
                                                <div class="skeleton label-skeleton label-loader"></div>
                                                <h5 class="d-none real-label"><span class="counter totalOrder"></span></h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card dash-widget">
                                <div class="card-body">
                                    <div class="d-flex  justify-content-between align-items-center">
                                        <div class="d-flex align-items-center">
                                            <span class="dash-icon bg-secondary-transparent d-flex justify-content-center align-items-center rounded-circle">
                                                <i class="ti ti-wallet"></i>
                                            </span>
                                            <div class="ms-2">
                                                <div class="skeleton label-skeleton label-loader"></div>
                                                <span class="fs-14 d-none real-label">{{__('Total Spend')}}</span>
                                                <div class="skeleton label-skeleton label-loader"></div>
                                                <h5 class="d-none real-label"><span class="symbol"></span><span class="counter totalSpend"></span></h5>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="row">

                        <div class="col-xxl-6 col-lg-6 d-flex">
                            <div class="w-100">
                                <div class="skeleton label-skeleton label-loader"></div>
                                <h5 class="mb-3 d-none real-label">{{__('Recent Transaction')}}</h5>
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <tbody class="recentTranction">

                                        </tbody>
                                    </table>

                                </div>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-6 d-flex">
                            <div class="w-100">
                                <div class="skeleton label-skeleton label-loader"></div>
                                <h5 class="mb-3 d-none real-label">{{__('Recent Booking')}}</h5>
                                <div class="table-responsive">
                                    <table class="table mb-0">
                                        <tbody class="recent_booking">


                                        </tbody>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>


@endsection