@extends('front')

@section('content')

	<div class="breadcrumb-bar text-center">
		<div class="container">
			<div class="row">
				<div class="col-md-12 col-12">
					<h2 class="breadcrumb-title mb-2">{{__('Provider Detail')}}</h2>
					<nav aria-label="breadcrumb">
						<ol class="breadcrumb justify-content-center mb-0">
							<li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}"><i class="ti ti-home-2"></i></a></li>
							<li class="breadcrumb-item active" aria-current="page">{{__('Provider Detail')}}</li>
						</ol>
					</nav>
				</div>
			</div>
			<div class="breadcrumb-bg">
				<img src="/assets/img/bg/breadcrumb-bg-01.png" class="breadcrumb-bg-1" alt="Img">
				<img src="/assets/img/bg/breadcrumb-bg-02.png" class="breadcrumb-bg-2" alt="Img">
			</div>
		</div>
	</div>

	<div class="page-wrapper">
		<div class="content">
            <div id="pageLoader1" class="loader_front">
                <div>
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">..</span>
                    </div>
                </div>
            </div>
			<div class="container">
				<div class="row">
					<div class="col-xl-8">
						<div class="card border-0">
							<div class="card-body">
								<div class="service-head mb-2">
									<div class="d-flex align-items-center justify-content-between flex-wrap">
										<h3 class="mb-2" id="provider-name"></h3>
										<span class="badge badge-purple-transparent mb-2"><i class="ti ti-calendar-check me-1"></i><span id="provider-bookings">0</span>+ {{ __('Bookings') }}</span>
									</div>
									<div class="d-flex align-items-center justify-content-between flex-wrap mb-2">
										<div class="d-flex align-items-center flex-wrap">
											<p class="me-3 mb-2">
												<i class="ti ti-map-pin me-2"></i>
												<span id="provider-location"></span>
											</p>
											<p class="mb-2">
												<i class="ti ti-star-filled text-warning me-2"></i>
												<span class="text-gray-9" id="provider-rating-text">0.0</span> 
												(<span id="provider-reviews">0</span> {{ __('reviews') }})
											</p>
										</div>
									</div>
								</div>

								<div class="accordion service-accordion">
									<div class="accordion-item mb-4">
										<h2 class="accordion-header">
											<button class="accordion-button p-0" type="button" data-bs-toggle="collapse" data-bs-target="#overview" aria-expanded="false">
												{{ __('Provider Overview') }}
											</button>
										</h2>
										<div id="overview" class="accordion-collapse collapse show">
											<div class="accordion-body border-0 p-0 pt-3">
												<div class="more-text">
													<p id="provider-bio"></p>
												</div>
											</div>
										</div>
									</div>

									<div class="accordion-item mb-4">
										<h2 class="accordion-header">
											<button class="accordion-button p-0" type="button" data-bs-toggle="collapse" data-bs-target="#categories" aria-expanded="false">
												{{ __('Categories & Services') }}
											</button>
										</h2>
										<div id="categories" class="accordion-collapse collapse show">
											<div class="accordion-body border-0 p-0 pt-3">
												<div class="row">
													<div class="col-md-6 mb-3">
														<h6 class="text-dark fw-medium mb-3">{{ __('Main Category') }}</h6>
														<div id="provider-main-category">
															<!-- Dynamic category will be loaded here -->
														</div>
													</div>
													<div class="col-md-6 mb-3">
														<h6 class="text-dark fw-medium mb-3">{{ __('Subcategories') }}</h6>
														<div id="provider-subcategories">
															<!-- Dynamic subcategories will be loaded here -->
														</div>
													</div>
												</div>
												<div class="row mt-3">
													<div class="col-12">
														<h6 class="text-dark fw-medium mb-3">{{ __('Services Offered') }}</h6>
														<div id="provider-services-count">
															<!-- Dynamic services count will be loaded here -->
														</div>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>

					<div class="col-xl-4 theiaStickySidebar">
						<!-- Book Service Button -->
						<a href="/services?provider=64" class="btn btn-lg btn-primary w-100 d-flex align-items-center justify-content-center mb-3 provider_id">
							<i class="ti ti-calendar me-2"></i>{{ __('Book Service') }}
						</a>

						<!-- Service Provider Info Card -->
						<div class="card border-0">
							<div class="card-body">
								<h4 class="mb-3">{{ __('Service Provider') }}</h4>
								<div class="provider-info text-center bg-light-500 p-3 mb-3">
									<div class="mb-3">
										<img src="/assets/img/profile-default.png" alt="img" class="img-fluid" id="provider-profile-image" style="width: 120px; height: 150px; object-fit: cover; border: 2px solid #e5e7eb; border-radius: 8px;">
										<span class="service-active-dot"><i class="ti ti-check"></i></span>
									</div>
									<h5 id="provider-name-sidebar"></h5>
									<p class="fs-14">
										<i class="ti ti-star-filled text-warning me-2"></i>
										<span class="text-gray-9 fw-semibold" id="provider-rating-sidebar">0.0</span> 
										(<span id="provider-reviews-sidebar">0</span> {{ __('reviews') }})
									</p>
								</div>
								<div class="d-flex align-items-center justify-content-between mb-3">
									<h6 class="fs-16 fw-medium mb-0"><i class="ti ti-user text-default me-2"></i>{{ __('Member Since') }}</h6>
									<p id="provider-member-since"></p>
								</div>
								<div class="d-flex align-items-center justify-content-between mb-3">
									<h6 class="fs-16 fw-medium mb-0"><i class="ti ti-map-pin me-1"></i>{{ __('Address') }}</h6>
									<p id="provider-address-sidebar"></p>
								</div>
								<div class="d-flex align-items-center justify-content-between mb-3">
									<h6 class="fs-16 fw-medium mb-0"><i class="ti ti-mail me-1"></i>{{ __('Email') }}</h6>
									<p id="provider-email-sidebar"></p>
								</div>
								<div class="d-flex align-items-center justify-content-between mb-3">
									<h6 class="fs-16 fw-medium mb-0"><i class="ti ti-phone me-1"></i>{{ __('Phone') }}</h6>
									<p id="provider-phone-sidebar"></p>
								</div>
								<div class="d-flex align-items-center justify-content-between mb-3">
									<h6 class="fs-16 fw-medium mb-0"><i class="ti ti-file-text me-1"></i>{{ __('No of Listings') }}</h6>
									<p id="provider-listings"></p>
								</div>
								<div class="d-flex align-items-center justify-content-between mb-3">
									<h6 class="fs-16 fw-medium mb-0"><i class="ti ti-file-text me-1"></i>{{ __('Social Profiles') }}</h6>
									<div class="social-icon d-flex align-items-center gap-2" id="provider-social-links">
										<!-- Dynamic social links will be loaded here -->
									</div>
								</div>
							</div>
						</div>

						<!-- Location Card -->
						<div class="card border-0">
							<div class="card-body">
								<h4 class="mb-3">{{ __('Location') }}</h4>
								<div class="map-wrap">
									<div id="provider-map-container">
										<div class="text-center">
											<div class="spinner-border" role="status">
												<span class="visually-hidden">Loading map...</span>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

								<div class="accordion" id="accordionPanelsStayOpenExample">
									<div class="accordion-item mb-3 d-none">
										<div class="accordion-header" id="accordion-headingOne">
											<div class="accordion-button p-0" data-bs-toggle="collapse" data-bs-target="#accordion-collapseOne" aria-expanded="true" aria-controls="accordion-collapseOne" role="button">
												{{__('Overview')}}
											</div>
										</div>
										<div id="accordion-collapseOne" class="accordion-collapse collapse show" aria-labelledby="accordion-headingOne">
										<div class="accordion-body p-0 mt-3 pb-1">
											<div class="more-text">
												<p class="mb-4">We bring over 20 years of expertise to your doorstep, offering a full range of electrical
													services tailored to meet the needs of homeowners, businesses, and industrial clients. Our
													commitment to safety, reliability, and customer satisfaction has
													made us a trusted name in the industry. Whether you're in need of
													a simple repair or a complex installation, our team of certified electricians is here to help.
												</p>
												<p>we bring over 20 years of expertise to your doorstep, offering a full range of electrical services tailored to meet the needs of homeowners, businesses, and industrial clients. </p>
											</div>
											<a href="javascript:void(0);" class="text-primary d-inline-block more-btn mb-2">Read More</a>
										</div>
										</div>
									</div>
									<div class="accordion-item mb-3 d-none">
										<div class="accordion-header" id="accordion-headingTwo">
											<div class="accordion-button p-0" data-bs-toggle="collapse" data-bs-target="#accordion-collapseTwo" aria-expanded="true" aria-controls="accordion-collapseTwo" role="button">
												Area Of Expertise
											</div>
										</div>
										<div id="accordion-collapseTwo" class="accordion-collapse collapse show" aria-labelledby="accordion-headingTwo">
										<div class="accordion-body p-0 mt-3 pb-1">
											<P>From small residential repairs to large-scale commercial and industrial projects,
												is your go-to provider for all electrical needs. Contact us today to schedule a
												consultation or to learn more about how we can assist with your next project.
											</P>
											<div>
												<div class="row g-3">
													<div class="col-xl-12">
														<div class="area-expert-slider owl-carousel mb-3">
															<div class="text-center area-expert">
																<span class="d-block mb-2"><img src="/front/img/icons/consultation-icon-01.svg" class="w-auto m-auto" alt="Img"></span>
																<p class="fw-medium fs-14">Construction</p>
															</div>
															<div class="text-center area-expert">
																<span class="d-block mb-2"><img src="/front/img/icons/consultation-icon-02.svg" class="w-auto m-auto" alt="Img"></span>
																<p class="fw-medium fs-14">Car Wash</p>
															</div>
															<div class="text-center area-expert">
																<span class="d-block mb-2"><img src="/front/img/icons/consultation-icon-03.svg" class="w-auto m-auto" alt="Img"></span>
																<p class="fw-medium fs-14">Electrical</p>
															</div>
															<div class="text-center area-expert">
																<span class="d-block mb-2"><img src="/front/img/icons/consultation-icon-04.svg" class="w-auto m-auto" alt="Img"></span>
																<p class="fw-medium fs-14">Cleaning</p>
															</div>
															<div class="text-center area-expert">
																<span class="d-block mb-2"><img src="/front/img/icons/consultation-icon-05.svg" class="w-auto m-auto" alt="Img"></span>
																<p class="fw-medium fs-14">Carpentry</p>
															</div>
															<div class="text-center area-expert">
																<span class="d-block mb-2"><img src="/front/img/icons/consultation-icon-06.svg" class="w-auto m-auto" alt="Img"></span>
																<p class="fw-medium fs-14">Plumbing</p>
															</div>
														</div>
													</div>
												</div>
											</div>
										</div>
										</div>
									</div>

									<div class="accordion-item mb-3">
										<div class="accordion-header" id="accordion-headingFour">
											<div class="accordion-button p-0" data-bs-toggle="collapse" data-bs-target="#accordion-collapseFour" aria-expanded="true" aria-controls="accordion-collapseFour" role="button">
												{{__('Our Services')}}
											</div>
										</div>
										<div id="accordion-collapseFour" class="accordion-collapse collapse show" aria-labelledby="accordion-headingFour">
										<div class="accordion-body p-0 mt-3 pb-1">
											<div class="row">
												<div class="col-md-12">
													<div class="our-services-slider custom-owl-dot owl-carousel product_details">


													</div>
												</div>
											</div>
										</div>
										</div>
									</div>
									<div class="accordion-item mb-3 d-none">
										<div class="accordion-header" id="accordion-headingSix">
											<div class="accordion-button p-0" data-bs-toggle="collapse" data-bs-target="#accordion-collapseSix" aria-expanded="true" aria-controls="accordion-collapseSix" role="button">
												{{__('Our Branches')}}
											</div>
										</div>
										<div id="accordion-collapseSix" class="accordion-collapse collapse show" aria-labelledby="accordion-headingSix">
										<div class="accordion-body p-0 mt-3 pb-1">
											<div class="our-branches-slider owl-carousel custom-owl-dot">


											</div>
										</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-xl-4 theiaStickySidebar">
						<div class="card shadow-none">
							<div class="card-body lh-1">
								<h4 class="mb-3">{{__('Location')}}</h4>
								<div id="provider-map-container">
									<div class="text-center">
										<div class="spinner-border" role="status">
											<span class="visually-hidden">Loading map...</span>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

@endsection
