@extends('front')

@section('content')

<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{__('Linked Practitioners')}}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{__('Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Linked Practitioners')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h5 class="card-title mb-0">
                                    <i class="ti ti-link me-2"></i>{{ __('Linked Practitioners') }}
                                </h5>
                                <div class="d-flex align-items-center">
                                    <button class="btn btn-primary btn-sm" id="refreshLinkedBtn">
                                        <i class="ti ti-refresh me-1"></i>{{ __('Refresh') }}
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12">
                                    <div class="table-responsive">
                                        <table class="table table-striped" id="linkedProvidersTable">
                                            <thead>
                                                <tr>
                                                    <th>{{ __('Practitioner Name') }}</th>
                                                    <th>{{ __('Email') }}</th>
                                                    <th>{{ __('Linked Date') }}</th>
                                                    <th>{{ __('Status') }}</th>
                                                    <th>{{ __('Actions') }}</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr>
                                                    <td colspan="5" class="text-center text-muted">
                                                        <span class="spinner-border spinner-border-sm me-2"></span>
                                                        {{ __('Loading linked practitioners...') }}
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Information Card -->
                            <div class="row mt-3">
                                <div class="col-12">
                                    <div class="card border-info shadow-sm">
                                        <div class="card-body text-center p-2">
                                            <div class="d-flex align-items-center justify-content-center mb-2">
                                                <div class="avatar avatar-sm bg-info-transparent rounded-circle me-2">
                                                    <i class="ti ti-info-circle fs-16 text-info"></i>
                                                </div>
                                                <h6 class="card-title mb-0">{{ __('Practitioner Connections') }}</h6>
                                            </div>
                                            
                                            <div class="alert alert-info text-start mb-2 py-2">
                                                <i class="ti ti-circle-check me-2"></i>
                                                <strong>{{ __('How Linking Works') }}</strong><br>
                                                <small>{{ __('You become linked to a practitioner when they assign you a Paradigm assessment. This allows them to view your results and send you additional assessments.') }}</small>
                                            </div>
                                            
                                            <div class="text-start">
                                                <h6 class="mb-2 fs-14">{{ __('Practitioner Benefits:') }}</h6>
                                                <ul class="list-unstyled small mb-2">
                                                    <li class="mb-1">
                                                        <i class="ti ti-check text-success me-1"></i>
                                                        {{ __('Can assign you assessments') }}
                                                    </li>
                                                    <li class="mb-1">
                                                        <i class="ti ti-check text-success me-1"></i>
                                                        {{ __('Can view your assessment results') }}
                                                    </li>
                                                    <li class="mb-1">
                                                        <i class="ti ti-check text-success me-1"></i>
                                                        {{ __('Can send you email notifications') }}
                                                    </li>
                                                    <li class="mb-1">
                                                        <i class="ti ti-check text-success me-1"></i>
                                                        {{ __('Can generate reports for you') }}
                                                    </li>
                                                </ul>
                                            </div>
                                            
                                            <div class="alert alert-warning mb-0 py-2">
                                                <i class="ti ti-alert-triangle me-2"></i>
                                                <small><strong>{{ __('Unlinking Warning') }}</strong><br>
                                                {{ __('If you unlink from a practitioner, they will no longer be able to assign you new assessments or access your results. Existing assessment results will remain in your account.') }}</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Unlink Confirmation Modal -->
<div class="modal fade" id="unlinkModal" tabindex="-1" aria-labelledby="unlinkModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title" id="unlinkModalLabel">
                    <i class="ti ti-unlink me-2"></i>{{ __('Confirm Unlink') }}
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="alert alert-warning">
                    <i class="ti ti-alert-circle me-2"></i>
                    <strong>{{ __('Warning: This action cannot be undone!') }}</strong>
                </div>
                <p id="unlinkMessage">{{ __('Are you sure you want to unlink from this practitioner?') }}</p>
                <div class="mt-3">
                    <strong>{{ __('This will prevent:') }}</strong>
                    <ul class="mt-2">
                        <li>{{ __('New assessment assignments') }}</li>
                        <li>{{ __('Access to your assessment results') }}</li>
                        <li>{{ __('Email notifications from this practitioner') }}</li>
                    </ul>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                    <i class="ti ti-x me-2"></i>{{ __('Cancel') }}
                </button>
                <button type="button" class="btn btn-warning" id="confirmUnlinkBtn">
                    <i class="ti ti-unlink me-2"></i>{{ __('Unlink') }}
                </button>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    let unlinkProviderId = null;
    
    // Load linked providers on page load
    loadLinkedProviders();
    
    // Refresh button
    $('#refreshLinkedBtn').on('click', function() {
        loadLinkedProviders();
    });
    
    // Unlink button handler
    $(document).on('click', '.unlink-provider-btn', function() {
        const providerId = $(this).data('provider-id');
        const providerName = $(this).data('provider-name');
        
        unlinkProviderId = providerId;
        $('#unlinkMessage').text(`Are you sure you want to unlink from ${providerName}?`);
        $('#unlinkModal').modal('show');
    });
    
    // Confirm unlink
    $('#confirmUnlinkBtn').on('click', function() {
        if (unlinkProviderId) {
            unlinkProvider(unlinkProviderId);
        }
    });
    
    function loadLinkedProviders() {
        $.ajax({
            url: '{{ route("user.linked.providers") }}',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    displayLinkedProviders(response.providers);
                } else {
                    showError('Failed to load linked providers');
                }
            },
            error: function() {
                showError('Error loading linked providers');
            }
        });
    }
    
    function displayLinkedProviders(providers) {
        let html = '';
        
        if (providers.length === 0) {
            html = `
                <tr>
                    <td colspan="5" class="text-center text-muted">
                        <i class="ti ti-users-off fs-32 mb-3 d-block"></i>
                        <p class="mb-0">{{ __('No linked practitioners found') }}</p>
                        <small>{{ __('You will appear here once a practitioner assigns you an assessment.') }}</small>
                    </td>
                </tr>
            `;
        } else {
            providers.forEach(function(provider) {
                const linkedDate = new Date(provider.linked_date).toLocaleDateString();
                const statusBadge = provider.status === 'active' 
                    ? '<span class="badge bg-success">Active</span>'
                    : '<span class="badge bg-secondary">Inactive</span>';
                
                html += `
                    <tr>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="avatar avatar-sm bg-primary-transparent rounded-circle me-3">
                                    <span class="avatar-initials">${provider.name.charAt(0).toUpperCase()}</span>
                                </div>
                                <div>
                                    <strong>${provider.name}</strong>
                                    ${provider.business_name ? `<br><small class="text-muted">${provider.business_name}</small>` : ''}
                                </div>
                            </div>
                        </td>
                        <td>${provider.email}</td>
                        <td>${linkedDate}</td>
                        <td>${statusBadge}</td>
                        <td>
                            <button class="btn btn-sm btn-warning unlink-provider-btn" 
                                    data-provider-id="${provider.id}"
                                    data-provider-name="${provider.name}"
                                    title="Unlink Provider">
                                <i class="ti ti-unlink"></i> Unlink
                            </button>
                        </td>
                    </tr>
                `;
            });
        }
        
        $('#linkedProvidersTable tbody').html(html);
    }
    
    function unlinkProvider(providerId) {
        $.ajax({
            url: '{{ route("user.unlink.provider") }}',
            method: 'POST',
            data: {
                provider_id: providerId,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    $('#unlinkModal').modal('hide');
                    showSuccess(response.message);
                    loadLinkedProviders(); // Refresh the list
                } else {
                    showError(response.message);
                }
            },
            error: function(xhr) {
                const response = xhr.responseJSON;
                showError(response?.message || 'Failed to unlink provider');
            }
        });
    }
    
    function showSuccess(message) {
        if (typeof toastr !== 'undefined') {
            toastr.success(message);
        } else {
            alert(message);
        }
    }
    
    function showError(message) {
        if (typeof toastr !== 'undefined') {
            toastr.error(message);
        } else {
            alert(message);
        }
    }
});
</script>
@endpush