@extends('front')

@section('content')

<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{__('My Paradigm Profile')}}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{__('Dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('My Paradigm Profile')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    
                    @if(false)
                    <!-- Wallet Balance Card - Hidden -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="d-flex align-items-center">
                                    <div class="avatar avatar-md bg-success-transparent rounded-circle me-3">
                                        <i class="ti ti-wallet fs-20"></i>
                                    </div>
                                    <div>
                                        <p class="text-muted mb-1 small">{{ __('Your Wallet Balance') }}</p>
                                        <h4 class="mb-0" id="user_wallet_balance">
                                            <span class="spinner-border spinner-border-sm" role="status"></span>
                                        </h4>
                                    </div>
                                </div>
                                <div>
                                    <a href="{{ route('user.wallet') }}" class="btn btn-outline-success btn-sm">
                                        <i class="ti ti-plus me-1"></i>{{ __('Top Up') }}
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    
                    <div class="card">
                        <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <div class="table-responsive">
                                    <table class="table table-striped" id="assessmentsTable">
                                        <thead>
                                            <tr>
                                                <th>{{ __('Assessment') }}</th>
                                                <th>{{ __('Payment') }}</th>
                                                <th>{{ __('Status') }}</th>
                                                <th>{{ __('Assigned Date') }}</th>
                                                <th>{{ __('Actions') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="5" class="text-center text-muted">
                                                    <span class="spinner-border spinner-border-sm me-2"></span>
                                                    {{ __('Loading assessments...') }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Assessment Instructions moved below the table -->
                        <div class="row mt-3">
                            <div class="col-12">
                                <div class="card border-primary shadow-sm">
                                    <div class="card-body text-center p-3">
                                        <div class="d-flex align-items-center justify-content-center mb-2">
                                            <div class="avatar avatar-sm bg-primary-transparent rounded-circle me-2">
                                                <i class="ti ti-brain fs-16 text-primary"></i>
                                            </div>
                                            <h6 class="card-title mb-0">{{ __('Assessment Instructions') }}</h6>
                                        </div>
                                        
                                        <div class="alert alert-success text-start mb-2 py-2">
                                            <i class="ti ti-circle-check me-2"></i>
                                            <strong>{{ __('Your Assignments') }}</strong><br>
                                            <small>{{ __('All assessments assigned to you by your practitioner appear in the table above.') }}</small>
                                        </div>
                                        
                                        <div class="text-start">
                                            <h6 class="mb-2 fs-14">{{ __('How it Works:') }}</h6>
                                            <ul class="list-unstyled small mb-2">
                                                <li class="mb-1">
                                                    <i class="ti ti-check text-success me-1"></i>
                                                    {{ __('Practitioner assigns assessment') }}
                                                </li>
                                                <li class="mb-1">
                                                    <i class="ti ti-check text-success me-1"></i>
                                                    {{ __('You receive email notification') }}
                                                </li>
                                                <li class="mb-1">
                                                    <i class="ti ti-check text-success me-1"></i>
                                                    {{ __('Log in to see assignments') }}
                                                </li>
                                                <li class="mb-1">
                                                    <i class="ti ti-check text-success me-1"></i>
                                                    {{ __('Click "Start" to begin') }}
                                                </li>
                                                <li class="mb-1">
                                                    <i class="ti ti-check text-success me-1"></i>
                                                    {{ __('Complete assessment') }}
                                                </li>
                                                <li>
                                                    <i class="ti ti-check text-success me-1"></i>
                                                    {{ __('View results anytime') }}
                                                </li>
                                            </ul>
                                        </div>
                                        
                                        <div class="alert alert-info mb-0 py-2">
                                            <i class="ti ti-info-circle me-2"></i>
                                            <small><strong>{{ __('Need Help?') }}</strong><br>
                                            {{ __('Contact your practitioner if you don\'t see any assessments or have questions.') }}</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Load wallet balance
    loadWalletBalance();
    
    // Load user's assessments
    loadUserAssessments();
    
    function loadUserAssessments() {
        $.ajax({
            url: '{{ route("user.paradigm.my-assessments") }}',
            method: 'GET',
            success: function(response) {
                console.log('User assessments loaded:', response);
                if (response && response.length > 0) {
                    let html = '';
                    response.forEach(function(assessment) {
                        // Payment Status Badge
                        let paymentBadge = '';
                        // Check if self-purchased first
                        if (assessment.self_purchased == 1) {
                            paymentBadge = '<span class="badge bg-success">Paid</span>';
                        } else if (assessment.paid_by === 'free') {
                            paymentBadge = '<span class="badge bg-success">Free</span>';
                        } else if (assessment.paid_by === 'provider') {
                            paymentBadge = '<span class="badge bg-info">Paid</span>';
                        } else if (assessment.paid_by === 'client') {
                            if (assessment.payment_status === 'paid') {
                                paymentBadge = '<span class="badge bg-success">Paid</span>';
                            } else {
                                paymentBadge = '<span class="badge bg-warning text-dark">Payment Required</span>';
                            }
                        } else {
                            paymentBadge = '<span class="badge bg-secondary">Unknown</span>';
                        }
                        
                        // Assessment Status Badge
                        let statusBadge = '';
                        let actionBtn = '';
                        
                        if (assessment.result_status === 'completed') {
                            statusBadge = '<span class="badge bg-success">Completed</span>';
                            actionBtn = `
                                <button class="btn btn-sm btn-success download-result-btn" 
                                        data-result-id="${assessment.result_id}"
                                        title="Download Report">
                                    <i class="ti ti-download"></i> Download
                                </button>
                            `;
                        } else if (assessment.result_status === 'started') {
                            statusBadge = '<span class="badge bg-info">In Progress</span>';
                            actionBtn = `
                                <button class="btn btn-sm btn-warning continue-assessment-btn" 
                                        data-payment-id="${assessment.payment_id}"
                                        data-template-id="${assessment.template_id}">
                                    <i class="ti ti-refresh"></i> Continue
                                </button>
                            `;
                        } else {
                            statusBadge = '<span class="badge bg-warning">Pending</span>';
                            // Check if payment is required
                            if (assessment.paid_by === 'client' && assessment.payment_status !== 'paid') {
                                actionBtn = `
                                    <button class="btn btn-sm btn-warning pay-assessment-btn" 
                                            data-payment-id="${assessment.payment_id}" 
                                            data-template-id="${assessment.template_id}"
                                            data-paid-by="${assessment.paid_by}"
                                            data-payment-status="${assessment.payment_status}"
                                            data-amount="${assessment.amount}">
                                        <i class="ti ti-credit-card"></i> Pay
                                    </button>
                                `;
                            } else {
                                actionBtn = `
                                    <span class="text-muted small">
                                        <i class="ti ti-link"></i> {{ __('Use WhatsApp/Email Link') }}
                                    </span>
                                `;
                            }
                        }
                        
                        // Format assigned date
                        let assignedDate = assessment.created_at ? new Date(assessment.created_at).toLocaleDateString() : 'N/A';
                        
                        html += `
                            <tr>
                                <td><strong>${assessment.template_name}</strong></td>
                                <td>${paymentBadge}</td>
                                <td>${statusBadge}</td>
                                <td>${assignedDate}</td>
                                <td>${actionBtn}</td>
                            </tr>
                        `;
                    });
                    $('#assessmentsTable tbody').html(html);
                    
                    // Attach click handler for start buttons
                    $('.start-assessment-btn').on('click', function() {
                        handleStartAssessment($(this));
                    });
                    
                    // Attach click handler for pay buttons
                    $('.pay-assessment-btn').on('click', function() {
                        handlePayAssessment($(this));
                    });
                    
                    // Attach click handler for continue buttons
                    $('.continue-assessment-btn').on('click', function() {
                        const templateId = $(this).data('template-id');
                        window.location.href = '{{ route("paradigm.assessment.show", ":id") }}'.replace(':id', templateId);
                    });
                    
                    // Attach click handler for download result buttons
                    $('.download-result-btn').on('click', function() {
                        const resultId = $(this).data('result-id');
                        window.location.href = '{{ route("paradigm.results", ":resultId") }}'.replace(':resultId', resultId);
                    });
                } else {
                    $('#assessmentsTable tbody').html('<tr><td colspan="5" class="text-center text-muted">{{ __("No assessments assigned yet. Contact your practitioner to get started.") }}</td></tr>');
                }
            },
            error: function(xhr) {
                console.error('Failed to load assessments:', xhr);
                $('#assessmentsTable tbody').html('<tr><td colspan="5" class="text-center text-danger">{{ __("Failed to load assessments") }}</td></tr>');
            }
        });
    }
    
    function loadWalletBalance() {
        $.ajax({
            url: '{{ route("user.wallet.balance") }}',
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    const balance = parseFloat(response.balance).toFixed(2);
                    $('#user_wallet_balance').html(`<span class="text-success">${balance} Credits</span>`);
                } else {
                    $('#user_wallet_balance').html('<span class="text-danger">Error</span>');
                }
            },
            error: function(xhr) {
                console.error('Failed to load wallet balance:', xhr);
                $('#user_wallet_balance').html('<span class="text-muted">-</span>');
            }
        });
    }
    
    function handleStartAssessment(button) {
        const paymentId = button.data('payment-id');
        const templateId = button.data('template-id');
        const paidBy = button.data('paid-by');
        const paymentStatus = button.data('payment-status');
        const amount = parseFloat(button.data('amount'));
        
        console.log('Starting assessment:', {paymentId, templateId, paidBy, paymentStatus, amount});
        
        // If free or provider paid, start immediately
        if (paidBy === 'free' || paidBy === 'provider') {
            window.location.href = '{{ route("paradigm.assessment.show", ":id") }}'.replace(':id', templateId);
            return;
        }
        
        // If client pays and already paid, start immediately
        if (paidBy === 'client' && paymentStatus === 'paid') {
            window.location.href = '{{ route("paradigm.assessment.show", ":id") }}'.replace(':id', templateId);
            return;
        }
    }
    
    function handlePayAssessment(button) {
        const paymentId = button.data('payment-id');
        const templateId = button.data('template-id');
        const amount = parseFloat(button.data('amount'));
        
        // Show payment modal
        showPaymentModal(paymentId, templateId, amount);
    }
    
    function showPaymentModal(paymentId, templateId, amount) {
        // Get current wallet balance
        const balanceText = $('#user_wallet_balance').text().trim();
        const balanceMatch = balanceText.match(/[\d.]+/);
        const currentBalance = balanceMatch ? parseFloat(balanceMatch[0]) : 0;
        
        const currency = 'Credits'; // Display as Credits
        const formattedAmount = amount.toFixed(2);
        
        let modalHtml = `
            <div class="modal fade" id="paymentModal" tabindex="-1" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header bg-primary text-white">
                            <h5 class="modal-title"><i class="ti ti-wallet me-2"></i>{{ __('Payment Required') }}</h5>
                            <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <div class="alert alert-info mb-3">
                                <i class="ti ti-info-circle me-2"></i>
                                <strong>{{ __('Assessment Fee:') }}</strong> ${formattedAmount} Credits
                            </div>
                            <div class="alert alert-${currentBalance >= amount ? 'success' : 'warning'}">
                                <i class="ti ti-wallet me-2"></i>
                                <strong>{{ __('Your Wallet Balance:') }}</strong> ${currentBalance.toFixed(2)} Credits
                            </div>
                            ${currentBalance < amount ? `
                                <div class="alert alert-danger">
                                    <i class="ti ti-alert-circle me-2"></i>
                                    {{ __('Insufficient balance. Please top up your wallet first.') }}
                                </div>
                                <a href="{{ route('user.wallet') }}" class="btn btn-primary w-100">
                                    <i class="ti ti-plus me-2"></i>{{ __('Top Up Wallet') }}
                                </a>
                            ` : `
                                <button type="button" class="btn btn-success w-100" id="confirmPaymentBtn" data-payment-id="${paymentId}" data-template-id="${templateId}">
                                    <i class="ti ti-check me-2"></i>{{ __('Pay & Start Assessment') }}
                                </button>
                            `}
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Remove existing modal if any
        $('#paymentModal').remove();
        
        // Add new modal to body
        $('body').append(modalHtml);
        
        // Show modal
        const modal = new bootstrap.Modal(document.getElementById('paymentModal'));
        modal.show();
        
        // Handle payment confirmation
        $('#confirmPaymentBtn').on('click', function() {
            processWalletPayment(paymentId, templateId);
        });
    }
    
    function processWalletPayment(paymentId, templateId) {
        const button = $('#confirmPaymentBtn');
        button.prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-2"></span>{{ __("Processing...") }}');
        
        $.ajax({
            url: '{{ route("paradigm.payment.process-wallet") }}',
            method: 'POST',
            data: {
                payment_id: paymentId,
                _token: $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    toastr.success('{{ __("Payment successful! Starting assessment...") }}');
                    setTimeout(function() {
                        window.location.href = '{{ route("paradigm.assessment.show", ":id") }}'.replace(':id', templateId);
                    }, 1000);
                } else {
                    toastr.error(response.message || '{{ __("Payment failed") }}');
                    button.prop('disabled', false).html('<i class="ti ti-check me-2"></i>{{ __("Pay & Start Assessment") }}');
                }
            },
            error: function(xhr) {
                console.error('Payment error:', xhr);
                const errorMsg = xhr.responseJSON?.message || '{{ __("Payment processing failed") }}';
                toastr.error(errorMsg);
                button.prop('disabled', false).html('<i class="ti ti-check me-2"></i>{{ __("Pay & Start Assessment") }}');
            }
        });
    }
});
</script>

<style>
.avatar-md {
    width: 50px;
    height: 50px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.bg-success-transparent {
    background-color: rgba(40, 199, 111, 0.1);
    color: #28c76f;
}

.fs-20 {
    font-size: 20px;
}
</style>
@endpush
