@extends('front')

@section('content')

<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{__('Buy Paradigm Assessment')}}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center">
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{__('Dashboard')}}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.paradigm.assessments') }}">{{__('Paradigm Profiles™')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('Buy Assessment')}}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                <div class="col-xl-9 col-lg-8">
                    
                    @if(false)
                    <!-- Wallet Balance Card - Hidden -->
                    <div class="card mb-4">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <h6 class="text-muted mb-1">{{__('Your Wallet Balance')}}</h6>
                                    <h3 class="mb-0">{{ number_format($balance, 2) }} Credits</h3>
                                </div>
                                <a href="{{ route('user.wallet') }}" class="btn btn-outline-primary">
                                    <i class="ti ti-plus me-1"></i>{{__('Top Up Wallet')}}
                                </a>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Assessment Purchase Card -->
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title mb-0">{{__('Purchase Your Paradigm Profile™ Assessment')}}</h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="text-center mb-4">
                                        <i class="ti ti-brain text-primary" style="font-size: 64px;"></i>
                                        <h5 class="mt-3">{{__('Unlock Your Paradigm Profile™')}}</h5>
                                        <p class="text-muted">{{__('Take the comprehensive assessment and discover your unique Paradigm profile')}}</p>
                                    </div>

                                    <!-- Pricing -->
                                    <div class="pricing-box border rounded p-4 mb-4">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h5 class="mb-0">{{__('Assessment Price')}}</h5>
                                            @if($pricing->price > 0)
                                                <h3 class="text-primary mb-0">{{ number_format($pricing->price, 2) }} Credits</h3>
                                            @else
                                                <h3 class="text-success mb-0">{{__('FREE')}}</h3>
                                            @endif
                                        </div>
                                        @if($pricing->price > 0)
                                            <div class="d-flex justify-content-between align-items-center mb-2">
                                                <span class="text-muted">{{__('Price (ZAR)')}}:</span>
                                                <strong class="text-primary">R{{ number_format($package->final_price_zar ?? $pricing->price_zar ?? 0, 2) }}</strong>
                                            </div>
                                            <p class="text-muted mb-0">{{__('One-time payment for lifetime access to your profile')}}</p>
                                        @else
                                            <p class="text-success mb-0">{{__('This assessment is currently free! Get yours now.')}}</p>
                                        @endif
                                    </div>

                                    <!-- What's Included -->
                                    <div class="mb-4">
                                        <h6 class="mb-3">{{__('What\'s Included:')}}</h6>
                                        <ul class="list-unstyled">
                                            <li class="mb-2"><i class="ti ti-check text-success me-2"></i>{{__('Comprehensive Paradigm assessment')}}</li>
                                            <li class="mb-2"><i class="ti ti-check text-success me-2"></i>{{__('Detailed profile report (PDF)')}}</li>
                                            <li class="mb-2"><i class="ti ti-check text-success me-2"></i>{{__('30-day access to assessment')}}</li>
                                            <li class="mb-2"><i class="ti ti-check text-success me-2"></i>{{__('Professional insights and analysis')}}</li>
                                        </ul>
                                    </div>

                                    <!-- Payment Button -->
                                    <div class="text-center">
                                        @if($pricing->price == 0)
                                            <!-- Free Assessment -->
                                            <button type="button" id="purchaseBtn" class="btn btn-success btn-lg px-5">
                                                <i class="ti ti-gift me-2"></i>{{__('Get Free Assessment')}}
                                            </button>
                                            <p class="text-success mt-3 mb-0">
                                                <i class="ti ti-info-circle me-1"></i>
                                                {{__('No payment required - completely free!')}}
                                            </p>
                                        @elseif($balance >= $pricing->price)
                                            <!-- Sufficient Balance -->
                                            <button type="button" id="purchaseBtn" class="btn btn-primary btn-lg px-5">
                                                <i class="ti ti-shopping-cart me-2"></i>{{__('Purchase with Wallet Credits')}}
                                            </button>
                                            <p class="text-muted mt-3 mb-0">
                                                <i class="ti ti-info-circle me-1"></i>
                                                {{ number_format($pricing->price, 2) }} Credits {{__('will be deducted from your wallet')}}
                                            </p>
                                        @else
                                            <!-- Insufficient Balance -->
                                            <div class="alert alert-warning">
                                                <i class="ti ti-alert-triangle me-2"></i>
                                                {{__('Insufficient wallet balance. You need')}} {{ number_format($pricing->price - $balance, 2) }} Credits {{__('more.')}}
                                            </div>
                                            <a href="{{ route('user.wallet') }}" class="btn btn-primary btn-lg px-5">
                                                <i class="ti ti-wallet me-2"></i>{{__('Top Up Wallet')}}
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const purchaseBtn = document.getElementById('purchaseBtn');
    const balance = {{ $balance }};
    const price = {{ $pricing->price }};
    
    if (purchaseBtn) {
        purchaseBtn.addEventListener('click', function() {
            // Double-check balance if not free
            if (price > 0 && balance < price) {
                toastr.error('{{__("Insufficient wallet balance. Please top up your wallet first.")}}');
                setTimeout(() => {
                    window.location.href = '{{ route("user.wallet") }}';
                }, 2000);
                return;
            }

            // No confirmation popup - proceed directly
            purchaseBtn.disabled = true;
            purchaseBtn.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>{{__("Processing...")}}';
            
            fetch('{{ route("user.paradigm.purchase") }}', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '{{ csrf_token() }}',
                    'Accept': 'application/json'
                }
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    toastr.success(data.message);
                    setTimeout(() => {
                        window.location.href = '{{ route("user.paradigm.my-paid") }}';
                    }, 1500);
                } else {
                    toastr.error(data.message);
                    purchaseBtn.disabled = false;
                    const btnText = price == 0 
                        ? '<i class="ti ti-gift me-2"></i>{{__("Get Free Assessment")}}' 
                        : '<i class="ti ti-shopping-cart me-2"></i>{{__("Purchase with Wallet Credits")}}';
                    purchaseBtn.innerHTML = btnText;
                }
            })
            .catch(error => {
                console.error('Error:', error);
                toastr.error('{{__("Error processing purchase")}}');
                purchaseBtn.disabled = false;
                const btnText = price == 0 
                    ? '<i class="ti ti-gift me-2"></i>{{__("Get Free Assessment")}}' 
                    : '<i class="ti ti-shopping-cart me-2"></i>{{__("Purchase with Wallet Credits")}}';
                purchaseBtn.innerHTML = btnText;
            });
        });
    }
});
</script>

@endsection

