@extends('front')

@section('content')

<!-- Breadcrumb -->
<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{ __('Buy Credits for Paradigm Profile') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="ti ti-home-2"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Buy Credits') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>
<!-- /Breadcrumb -->

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                
                <div class="col-xl-9 col-lg-8">
                    <!-- Page Header -->
                    <div class="d-flex justify-content-between align-items-center flex-wrap mb-4">
                        <h4>{{ __('Buy Credits for Paradigm Profile') }}</h4>
                        <div>
                            <a href="{{ route('user.dashboard') }}" class="btn btn-outline-secondary">
                                <i class="ti ti-arrow-left me-1"></i> {{ __('Back to Dashboard') }}
                            </a>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <!-- Credit Purchase Card -->
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title mb-0">{{ __('Purchase Credits') }}</h5>
                                </div>
                                <div class="card-body">
                                    <div class="text-center mb-4">
                                        <i class="ti ti-wallet text-primary" style="font-size: 64px;"></i>
                                        <h5 class="mt-3">{{ __('Credits Required for Paradigm Profile') }}</h5>
                                    </div>

                                    <!-- Credit Details -->
                                    <div class="pricing-box border rounded p-4 mb-4">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="mb-0">{{ __('Required Credits') }}:</h6>
                                            <h4 class="text-primary mb-0">{{ number_format($requiredCredits, 2) }} Credits</h4>
                                        </div>
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h6 class="mb-0">{{ __('Your Current Balance') }}:</h6>
                                            <h6 class="mb-0 {{ $currentBalance >= $requiredCredits ? 'text-success' : 'text-warning' }}">
                                                {{ number_format($currentBalance, 2) }} Credits
                                            </h6>
                                        </div>
                                        @if($currentBalance < $requiredCredits)
                                        <div class="d-flex justify-content-between align-items-center border-top pt-3">
                                            <h6 class="mb-0">{{ __('Package Credits') }}:</h6>
                                            <h5 class="text-primary mb-0">{{ number_format($requiredCredits, 2) }} Credits</h5>
                                        </div>
                                        @endif
                                    </div>

                                    @if($currentBalance >= $requiredCredits)
                                        <!-- Already has sufficient credits -->
                                        <div class="alert alert-success text-center">
                                            <i class="ti ti-check-circle me-2"></i>
                                            {{ __('You have sufficient credits!') }}
                                        </div>
                                        <div class="text-center mt-4">
                                            <a href="{{ route('user.paradigm.buy') }}" class="btn btn-primary btn-lg px-5">
                                                <i class="ti ti-arrow-right me-2"></i>{{ __('Proceed to Purchase Profile') }}
                                            </a>
                                        </div>
                                    @else
                                        <!-- Payment Method Selection -->
                                        <div class="mb-4">
                                            <h6 class="mb-3">{{ __('Payment Method') }}</h6>
                                            <div id="payment-methods-container">
                                                <div class="text-center py-4">
                                                    <div class="spinner-border text-primary" role="status">
                                                        <span class="visually-hidden">{{ __('Loading...') }}</span>
                                                    </div>
                                                    <p class="text-muted mt-2">{{ __('Loading payment methods...') }}</p>
                                                </div>
                                            </div>
                                            <div id="no-payment-methods" style="display: none;">
                                                <div class="alert alert-warning">
                                                    <i class="ti ti-alert-triangle me-2"></i>
                                                    {{ __('No active payment methods available. Please enable Stripe or PayFast in admin settings.') }}
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Price from package (set in /admin/paradigm/sales-settings) -->
                                        @php
                                            $creditsToBuy = $requiredCredits;
                                            $priceZAR = $package->final_price_zar;
                                            $priceUSD = $package->usd_equivalent;
                                        @endphp

                                        <!-- Summary -->
                                        <div class="border-top pt-3 mt-3">
                                            <div class="d-flex justify-content-between mb-2">
                                                <span>{{ __('Credits Package') }}:</span>
                                                <strong><span id="summary_credits">{{ number_format($creditsToBuy, 2) }} Credits</span></strong>
                                            </div>
                                            <div class="d-flex justify-content-between mb-2">
                                                <span>{{ __('Price') }}:</span>
                                                <strong><span id="summary_price">R{{ number_format($priceZAR, 2) }}</span></strong>
                                            </div>
                                            <div class="d-flex justify-content-between border-top pt-2">
                                                <h6>{{ __('Total') }}:</h6>
                                                <h5 class="text-primary mb-0"><span id="summary_total">R{{ number_format($priceZAR, 2) }}</span></h5>
                                            </div>
                                        </div>

                                        <!-- Proceed Button -->
                                        <div class="mt-4">
                                            <button type="button" class="btn btn-lg w-100" id="proceedPayment" style="background-color: #044f54; border-color: #044f54; color: white;" disabled>
                                                <i class="ti ti-lock me-2"></i>{{ __('Proceed to Payment') }}
                                            </button>
                                        </div>

                                        <!-- Info Alert -->
                                        <div class="alert alert-info mt-3 mb-0">
                                            <i class="ti ti-info-circle me-2"></i>
                                            {{ __('Credits will be added to your wallet immediately after successful payment. You will then be redirected to purchase your Paradigm Profile.') }}
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    @if($currentBalance < $requiredCredits)
    loadPaymentMethods();
    
    document.getElementById('proceedPayment').addEventListener('click', handlePayment);
    @endif
});

@if($currentBalance < $requiredCredits)
window.paradigmCreditsData = {
    credits: {{ number_format($requiredCredits, 2, '.', '') }},
    priceZAR: {{ number_format($priceZAR, 2, '.', '') }},
    priceUSD: {{ number_format($priceUSD, 2, '.', '') }},
    requiredCredits: {{ number_format($requiredCredits, 2, '.', '') }},
    packageId: {{ $package->id ?? 'null' }}
};

function loadPaymentMethods() {
    fetch('/api/getpaymentmethod', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(methods => {
        const container = document.getElementById('payment-methods-container');
        
        if (!methods || methods.length === 0) {
            document.getElementById('no-payment-methods').style.display = 'block';
            container.style.display = 'none';
            return;
        }
        
        let methodsHTML = '<div class="payment-methods-list">';
        let firstMethod = true;
        
        methods.forEach(method => {
            const methodName = method.label.toLowerCase();
            
            if (methodName === 'wallet' || methodName === 'paypal') {
                return;
            }
            
            let icon = '';
            let description = '';
            
            if (methodName === 'stripe') {
                icon = '<i class="ti ti-credit-card fs-24 text-primary me-3"></i>';
                description = '{{ __("Pay with Stripe") }}';
            } else if (methodName === 'payfast') {
                icon = '<i class="ti ti-credit-card fs-24 text-primary me-3"></i>';
                description = '{{ __("Pay with PayFast") }}';
            } else {
                return;
            }
            
            methodsHTML += `
                <div class="form-check payment-method-card mb-3">
                    <input class="form-check-input" type="radio" name="payment_method" 
                           id="payment_${methodName}" value="${methodName}" ${firstMethod ? 'checked' : ''}>
                    <label class="form-check-label w-100" for="payment_${methodName}">
                        <div class="d-flex align-items-center justify-content-between p-3 border rounded">
                            <div class="d-flex align-items-center">
                                ${icon}
                                <div>
                                    <h6 class="mb-0">${method.payment_type}</h6>
                                    <small class="text-muted">${description}</small>
                                </div>
                            </div>
                        </div>
                    </label>
                </div>
            `;
            firstMethod = false;
        });
        
        methodsHTML += '</div>';
        container.innerHTML = methodsHTML;
        
        document.querySelectorAll('input[name="payment_method"]').forEach(radio => {
            radio.addEventListener('change', function() {
                document.getElementById('proceedPayment').disabled = false;
            });
        });
        
        if (firstMethod === false) {
            document.getElementById('proceedPayment').disabled = false;
        }
    })
    .catch(error => {
        console.error('Error loading payment methods:', error);
        document.getElementById('payment-methods-container').style.display = 'none';
        document.getElementById('no-payment-methods').style.display = 'block';
    });
}

function handlePayment() {
    const paymentMethodRadio = document.querySelector('input[name="payment_method"]:checked');
    
    if (!paymentMethodRadio) {
        toastr.error('{{ __("Please select a payment method") }}');
        return;
    }
    
    const paymentMethod = paymentMethodRadio.value;
    const data = window.paradigmCreditsData;
    
    localStorage.setItem('buy_paradigm', '1');
    
    processParadigmCreditsPayment(data.priceZAR, data.credits, paymentMethod, data);
}

function processParadigmCreditsPayment(priceZAR, credits, paymentMethod, data) {
    const userId = {{ Auth::id() }};
    const csrfToken = '{{ csrf_token() }}';

    const packageId = data.packageId || window.paradigmCreditsData?.packageId || null;
    const packageData = {
        id: packageId,
        credits: credits,
        final_price_zar: priceZAR,
        final_price_usd: data.priceUSD || window.paradigmCreditsData?.priceUSD
    };

    fetch('/api/addWalletAmount', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': csrfToken
        },
        body: JSON.stringify({
            userId: userId,
            packageId: packageId,
            amount: priceZAR,
            credits: credits,
            paymentMethod: paymentMethod
        })
    })
    .then(response => response.json())
    .then(result => {
        if (result.success) {
            const trxId = result.data.transaction_id;
            
            if (paymentMethod === 'stripe') {
                processStripePayment(packageData.final_price_usd, trxId, csrfToken, packageData);
            } else if (paymentMethod === 'payfast') {
                processPayFastPayment(priceZAR, trxId, csrfToken, packageData);
            }
        } else {
            toastr.error(result.message || '{{ __("Error adding wallet record") }}');
        }
    })
    .catch(error => {
        console.error('Error:', error);
        toastr.error('{{ __("Error processing payment") }}');
    });
}

function processStripePayment(amount, trxId, csrfToken, packageData) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '{{ route("stripepayment") }}';
    
    const inputs = {
        '_token': csrfToken,
        'amount': amount,
        'type': 'user',
        'service_amount': amount,
        'trx_id': trxId,
        'usrname': '{{ Auth::user()->name }}',
        'user_id': {{ Auth::id() }},
        'paymenttype': 1,
        'package_id': packageData.id || null,
        'package_credits': packageData.credits,
        'name': '{{ Auth::user()->name }}',
        'payment_type': 'wallet'
    };
    
    for (const [key, value] of Object.entries(inputs)) {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = key;
        input.value = value;
        form.appendChild(input);
    }
    
    document.body.appendChild(form);
    form.submit();
}

function processPayFastPayment(amount, trxId, csrfToken, packageData) {
    const form = document.createElement('form');
    form.method = 'POST';
    form.action = '{{ route("payfastpayment") }}';
    
    const inputs = {
        '_token': csrfToken,
        'amount': amount,
        'trx_id': trxId,
        'type': 'user',
        'usrname': '{{ Auth::user()->name }}',
        'user_id': {{ Auth::id() }},
        'package_id': packageData.id || null,
        'package_credits': packageData.credits
    };
    
    for (const [key, value] of Object.entries(inputs)) {
        const input = document.createElement('input');
        input.type = 'hidden';
        input.name = key;
        input.value = value;
        form.appendChild(input);
    }
    
    document.body.appendChild(form);
    form.submit();
}
@endif
</script>
@endpush

