@extends('front')

@section('content')

<!-- Breadcrumb -->
<div class="breadcrumb-bar text-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-12">
                <h2 class="breadcrumb-title mb-2">{{ __('Payment Success') }}</h2>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb justify-content-center mb-0">
                        <li class="breadcrumb-item"><a href="{{ route('home') }}"><i class="ti ti-home-2"></i></a></li>
                        <li class="breadcrumb-item"><a href="{{ route('user.dashboard') }}">{{ __('Dashboard') }}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ __('Payment Success') }}</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>
<!-- /Breadcrumb -->

<!-- Page Wrapper -->
<div class="page-wrapper">
    <div class="content">
        <div class="container">
            <div class="row justify-content-center">
                @include('user.partials.sidebar')
                
                <div class="col-xl-9 col-lg-8">
                    <div class="row justify-content-center">
                        <div class="col-lg-8">
                            <!-- Payment Success Card -->
                            <div class="card text-center">
                                <div class="card-body p-5">
                                    <div class="mb-4">
                                        <div class="avatar avatar-xl bg-success-transparent rounded-circle mx-auto mb-3" style="width: 80px; height: 80px; display: flex; align-items: center; justify-content: center;">
                                            <i class="ti ti-check fs-40 text-success"></i>
                                        </div>
                                    </div>
                                    
                                    <h3 class="card-title mb-3">{{ __('Payment Successful!') }}</h3>
                                    <p class="text-muted mb-4" id="status-message">
                                        {{ __('Processing your assessment...') }}
                                    </p>
                                    
                                    <!-- Loading Spinner -->
                                    <div id="loading-spinner" class="mb-4">
                                        <div class="spinner-border text-primary" role="status">
                                            <span class="visually-hidden">{{ __('Loading...') }}</span>
                                        </div>
                                    </div>
                                    
                                    <!-- Success Message (hidden initially) -->
                                    <div id="success-message" style="display: none;">
                                        <p class="text-success mb-4">
                                            <i class="ti ti-check-circle me-2"></i>
                                            {{ __('Your assessment has been created successfully!') }}
                                        </p>
                                        <p class="text-muted mb-4">
                                            {{ __('Redirecting you to your assessment...') }}
                                        </p>
                                    </div>
                                    
                                    <!-- Error Message (hidden initially) -->
                                    <div id="error-message" style="display: none;">
                                        <p class="text-danger mb-4">
                                            <i class="ti ti-alert-circle me-2"></i>
                                            <span id="error-text"></span>
                                        </p>
                                        <div class="d-grid gap-2 d-md-flex justify-content-md-center">
                                            <a href="{{ route('user.paradigm.buy-credits') }}" class="btn btn-primary">
                                                <i class="ti ti-arrow-left me-2"></i>{{ __('Try Again') }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const transactionId = '{{ $transactionId ?? '' }}';
    
    if (!transactionId) {
        showError('{{ __("Invalid transaction. Please try again.") }}');
        return;
    }
    
    // Start processing assessment creation
    createAssessment(transactionId);
});

function createAssessment(transactionId, retryCount = 0) {
    const maxRetries = 3;
    const retryDelay = 3000; // 3 seconds
    
    fetch('/api/paradigm/create-assessment-after-payment', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            transaction_id: transactionId
        })
    })
    .then(response => {
        // Check if response is JSON
        const contentType = response.headers.get('content-type');
        if (contentType && contentType.includes('application/json')) {
            return response.json();
        } else {
            // If not JSON, read as text to see what we got
            return response.text().then(text => {
                console.error('Non-JSON response received:', text.substring(0, 200));
                throw new Error('Server returned an error page instead of JSON. Please check the server logs.');
            });
        }
    })
    .then(data => {
        if (data.success) {
            // Hide loading spinner
            document.getElementById('loading-spinner').style.display = 'none';
            
            // Show success message
            document.getElementById('status-message').textContent = '{{ __("Assessment created successfully!") }}';
            document.getElementById('success-message').style.display = 'block';
            
            // Redirect to assessment after 2 seconds
            setTimeout(() => {
                window.location.href = data.assessment_link;
            }, 2000);
        } else {
            // Check if it's a "credits processing" error and we can retry
            if (data.message && data.message.includes('Credits are still being processed') && retryCount < maxRetries) {
                // Update status message
                document.getElementById('status-message').textContent = `{{ __("Waiting for credits to be processed...") }} (${retryCount + 1}/${maxRetries})`;
                
                // Retry after delay
                setTimeout(() => {
                    createAssessment(transactionId, retryCount + 1);
                }, retryDelay);
            } else {
                showError(data.message || '{{ __("Failed to create assessment. Please try again.") }}');
            }
        }
    })
    .catch(error => {
        console.error('Error:', error);
        
        // Retry on network errors if we haven't exceeded max retries
        if (retryCount < maxRetries) {
            document.getElementById('status-message').textContent = `{{ __("Retrying...") }} (${retryCount + 1}/${maxRetries})`;
            setTimeout(() => {
                createAssessment(transactionId, retryCount + 1);
            }, retryDelay);
        } else {
            showError('{{ __("An error occurred. Please try again.") }}');
        }
    });
}

function showError(message) {
    document.getElementById('loading-spinner').style.display = 'none';
    document.getElementById('status-message').textContent = '{{ __("Payment was successful, but there was an issue creating your assessment.") }}';
    document.getElementById('error-text').textContent = message;
    document.getElementById('error-message').style.display = 'block';
}
</script>
@endpush

