<?php

namespace Tests\Feature;

use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Foundation\Testing\WithFaker;
use Tests\TestCase;
use App\Models\User;
use App\Models\ParadigmFormTemplate;
use App\Models\ParadigmPayment;

class ParadigmAssessmentProgressTest extends TestCase
{
    use RefreshDatabase;

    public function test_save_progress_endpoint()
    {
        // Create a user
        $user = User::factory()->create();
        
        // Create a template
        $template = ParadigmFormTemplate::factory()->create();
        
        // Create a payment
        $payment = ParadigmPayment::create([
            'template_id' => $template->id,
            'provider_id' => $user->id, // Just using user as provider for simplicity
            'client_id' => $user->id,
            'client_email' => $user->email,
            'amount' => 100,
            'currency' => 'USD',
            'status' => 'paid',
            'payment_link' => 'test-link-' . uniqid(),
            'paid_at' => now(),
        ]);

        // Mock progress data
        $progressData = [
            'personal' => ['name' => 'Test Name'],
            'questions' => ['1' => 'A']
        ];

        // Act as user
        $response = $this->actingAs($user)->postJson(route('templates.save-progress'), [
            'template_id' => $template->id,
            'progress_data' => $progressData,
        ]);

        // Assert success
        $response->assertStatus(200)
            ->assertJson(['success' => true]);

        // Assert database updated
        $this->assertDatabaseHas('paradigm_payments', [
            'id' => $payment->id,
            'progress_data' => json_encode($progressData)
        ]);
    }
}
